/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.wakeful;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;

public abstract class WakefulIntentService
extends IntentService {
    private static final String LOCK_NAME_STATIC = "com.commonsware.cwac.wakeful.WakefulIntentService";
    private static PowerManager.WakeLock lockStatic = null;

    protected abstract void doWakefulWork(Intent var1);

    private static synchronized PowerManager.WakeLock getLock(Context context) {
        if (lockStatic == null) {
            PowerManager mgr = (PowerManager)context.getSystemService("power");
            lockStatic = mgr.newWakeLock(1, LOCK_NAME_STATIC);
            lockStatic.setReferenceCounted(true);
        }
        return lockStatic;
    }

    public static void sendWakefulWork(Context ctxt, Intent i) {
        if (-1 == ctxt.getPackageManager().checkPermission("android.permission.WAKE_LOCK", ctxt.getPackageName())) {
            throw new RuntimeException("Application requires the WAKE_LOCK permission!");
        }
        WakefulIntentService.getLock(ctxt).acquire();
        ctxt.startService(i);
    }

    public static void sendWakefulWork(Context ctxt, Class clsService) {
        WakefulIntentService.sendWakefulWork(ctxt, new Intent(ctxt, clsService));
    }

    public WakefulIntentService(String name) {
        super(name);
    }

    public void onStart(Intent intent, int startId) {
        if (!WakefulIntentService.getLock((Context)this).isHeld()) {
            WakefulIntentService.getLock((Context)this).acquire();
        }
        super.onStart(intent, startId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onHandleIntent(Intent intent) {
        try {
            this.doWakefulWork(intent);
        }
        finally {
            WakefulIntentService.getLock((Context)this).release();
        }
    }
}

