/*
This file is part of Fwknop2.

    Fwknop2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 */
package biz.incomsystems.fwknop2;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;


/**
 * A list fragment representing a list of . This fragment
 * also supports tablet devices by allowing list items to be given an
 * 'activated' state upon selection. This helps indicate which item is
 * currently being viewed in a {@link ConfigDetailFragment}.
 * <p/>
 * Activities containing this fragment MUST implement the {@link Callbacks}
 * interface.
 */
public class ConfigListFragment extends ListFragment {
    public ArrayAdapter customAdapter;
    private AdapterView.AdapterContextMenuInfo info;
    ArrayList array_list = new ArrayList();
    DBHelper mydb;
    SendSPA OurSender;
    Button button;

    /**
     * The serialization (saved instance state) Bundle key representing the
     * activated item position. Only used on tablets.
     */
    private static final String STATE_ACTIVATED_POSITION = "activated_position";

    /**
     * The current activated item position. Only used on tablets.
     */
    private int mActivatedPosition = ListView.INVALID_POSITION;

    /**
     * A callback interface that all activities containing this fragment must
     * implement. This mechanism allows activities to be notified of item
     * selections.
     */
    public interface Callbacks {
        /**
         * Callback for when an item has been selected.
         */
       // void onUpdate();
        void onItemSelected(String id);
    }

    /**
     * A dummy implementation of the {@link Callbacks} interface that does
     * nothing. Used only when this fragment is not attached to an activity.
     */
    private Callbacks sDummyCallbacks = new Callbacks() {
        @Override
        public void onItemSelected(String id) {
        }
    };

    /**
     * The fragment's current callback object, which is notified of list item
     * clicks.
     */
    private Callbacks mCallbacks = sDummyCallbacks;


    /**
     * Mandatory empty constructor for the fragment manager to instantiate the
     * fragment (e.g. upon screen orientation changes).
     */
    public ConfigListFragment() {
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
        setMenuVisibility(true);

    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_list, container, false);
        button = (Button)rootView.findViewById(R.id.btn_send);
        button.setOnClickListener(
                new View.OnClickListener() {
                    public void onClick(View v) {
                        String nick = ((ConfigListActivity) getActivity()).selected_nick;
                        OurSender.reKnock = false;
                        OurSender.send(nick, getActivity());
                        //if we launch the service from here...  we can tell sender to
                    }

                });
        return rootView;
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        // Inflate the menu; this adds items to the action bar if it is present.
        super.onCreateOptionsMenu(menu, inflater);


        inflater.inflate(R.menu.list_menu, menu);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mydb = new DBHelper(getActivity());
        array_list = mydb.getAllConfigs();
        OurSender = new SendSPA();
        customAdapter = new ArrayAdapter<ArrayList>(
                getActivity(),
                android.R.layout.simple_list_item_activated_1,
                android.R.id.text1,
                array_list);
        setListAdapter(customAdapter);

        // Restore the previously serialized activated item position.
        if (savedInstanceState != null
                && savedInstanceState.containsKey(STATE_ACTIVATED_POSITION)) {
            setActivatedPosition(savedInstanceState.getInt(STATE_ACTIVATED_POSITION));
        }

    }
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.detail_help) {
            Intent detailIntent = new Intent(getActivity(), HelpActivity.class);
            startActivity(detailIntent);
        } else if (id == R.id.new_item) {
            Activity activity = getActivity();
            ConfigListActivity myactivity = (ConfigListActivity) activity;
            if (myactivity.mTwoPane){
                mCallbacks.onItemSelected("");
                //this.getListView().setItemChecked(mActivatedPosition, false);
                button.setVisibility(View.INVISIBLE);
                getListView().clearChoices();
                customAdapter.notifyDataSetChanged();

            } else {
                button.setVisibility(View.INVISIBLE);
                Intent detailIntent = new Intent(getActivity(), ConfigDetailActivity.class);
                detailIntent.putExtra(ConfigDetailFragment.ARG_ITEM_ID, "");
                startActivity(detailIntent);
            }


        } else if (id == R.id.detail_config) {
            Intent detailIntent = new Intent(getActivity(), GeneralConfigActivity.class);
            startActivity(detailIntent);
        } else {
            return false;
        }
        return true;
    }
        @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        OurSender.onActivityResult(requestCode, resultCode, data); // have to call this manually as it isn't an activity class
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        registerForContextMenu(this.getListView());
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);

        MenuInflater inflater = this.getActivity().getMenuInflater();
        inflater.inflate(R.menu.list_longtap_menu, menu);

        NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter(getActivity());
        if (nfcAdapter == null || !nfcAdapter.isEnabled()){
            menu.removeItem(R.id.write_nfc_tag);
        }
    }

    @Override
    public boolean onContextItemSelected(MenuItem item) {
        customAdapter = (ArrayAdapter) getListAdapter();
        info = (AdapterView.AdapterContextMenuInfo) item.getMenuInfo();
        switch (item.getItemId()) {
            case R.id.delete: // Deleting the selected option
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setMessage("Are you sure?").setPositiveButton("Yes", dialogClickListener)
                        .setNegativeButton("No", dialogClickListener).show();
                return true;

            case R.id.edit:
                Intent detailIntent = new Intent(getActivity(), ConfigDetailActivity.class);
                detailIntent.putExtra(ConfigDetailFragment.ARG_ITEM_ID, ((TextView) info.targetView).getText().toString());
                startActivity(detailIntent);
                return true;

            case R.id.write_nfc_tag:
                Intent nfcIntent = new Intent(getActivity(), WriteFwknopNickToNfcDialog.class);
                nfcIntent.putExtra(WriteFwknopNickToNfcDialog.ARG_ITEM_TARGET, ((TextView)info.targetView).getText().toString());
                startActivity(nfcIntent);

            default:
                return super.onContextItemSelected(item);
        }
    }

    public void onUpdate() {
        mydb = new DBHelper(getActivity());
        array_list.clear();
        array_list.addAll(mydb.getAllConfigs());
        customAdapter.notifyDataSetChanged();
        mydb.close();
    }
    DialogInterface.OnClickListener dialogClickListener = new DialogInterface.OnClickListener() {
        @Override
        public void onClick(DialogInterface dialog, int which) {
            switch (which){
                case DialogInterface.BUTTON_POSITIVE:
                    //Yes button clicked

                    String nick = ((TextView) info.targetView).getText().toString();
                    mydb.deleteConfig(nick);
                    array_list.remove(info.position);
                    customAdapter.notifyDataSetChanged();

                    break;

                case DialogInterface.BUTTON_NEGATIVE:
                    //No button clicked
                    break;
            }
        }
    };

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        mCallbacks = (Callbacks) activity;
    }
    @Override
    public void onDestroy() {
        super.onDestroy();

        if (OurSender.isConnected) {
            OurSender.client.stop(getActivity());
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();

        // Reset the active callbacks interface to the dummy implementation.
        mCallbacks = sDummyCallbacks;
    }

    @Override
    public void onListItemClick(ListView listView, View view, int position, long id) {
        super.onListItemClick(listView, view, position, id);
        mCallbacks.onItemSelected(this.getListAdapter().getItem(position).toString());
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (mActivatedPosition != ListView.INVALID_POSITION) {
            // Serialize and persist the activated item position.
            outState.putInt(STATE_ACTIVATED_POSITION, mActivatedPosition);
        }
    }

    /**
     * Turns on activate-on-click mode. When this mode is on, list items will be
     * given the 'activated' state when touched.
     */
    public void setActivateOnItemClick(boolean activateOnItemClick) {
        // When setting CHOICE_MODE_SINGLE, ListView will automatically
        // give items the 'activated' state when touched.
        getListView().setChoiceMode(activateOnItemClick
                ? ListView.CHOICE_MODE_SINGLE
                : ListView.CHOICE_MODE_NONE);
    }

    private void setActivatedPosition(int position) {
        if (position == ListView.INVALID_POSITION) {
            getListView().setItemChecked(mActivatedPosition, false);
        } else {
            getListView().setItemChecked(position, true);
        }

        mActivatedPosition = position;
    }

}
