# About Where are the Eyes

## Overview

Surveillance has recently come to the forefront of international attention, but there is a strong focus on *Internet* surveillance. While this is an important topic, we want to expand the discussion to include physical surveillance and the pervasive network of cameras surrounding us every day. We believe that our right to free speech and assembly requires understanding the environment in which we speak and assemble. To that end we have built a tool that illuminates the surveillance grid and helps inform citizens when they are being watched.

Where are the Eyes is a distributed mapping application. Each user contributes location data about the cameras near them, which is collated on our servers. By combining information from the community we can track the positions of cameras across the globe and send this data back to all our users. We periodically remove camera location pins from the map that haven't been seen recently, or have only been seen by one person. This increases the map's accuracy even if cameras are moved or removed.

## How do I use Where are the Eyes?

First, [register a username](/register) with us. This is used so that we can distinguish between different users that have seen the same camera.

Next, [download the app](/downloads) for iOS or Android, and enter your username in the app settings.

The map is now active: A blue dot represents your location, and red marks indicate the locations of cameras around you.

Each time you pass a camera on the streets, press the 'eye' button. The closer you are to the camera the more accurate our map will be. Please press the button even if the camera is already on our map - the more users verify that a camera exists the more certain we can be that it's real, and the more precise our map becomes.

**Note: Our map is much more accurate outdoors, where you can get a strong GPS signal.**

## <a name="faq"></a>FAQs

#### When *exactly* is my location sent online?

You regularly send us a *very approximate* location (your latitude and longitude rounded to integers) so that we can send you the locations of nearby cameras. This is done anonymously, and we do not log any coordinates we receive.

When you press the 'eye' button you send us your exact location, along with your username. This is so that we can get a precise recording of the camera location, and can tell when multiple users have verified the existence of a camera.

Note that your username is always [hashed](https://en.wikipedia.org/wiki/Cryptographic_hash_function) on our server. This means we can tell if you have already verified a camera exists, but someone with our database would have a hard time discovering which cameras a given user marked.

#### Won't criminals use this?

Criminals are used to looking for cameras, or "casing a joint". At worst our map only makes their jobs very slightly faster, but we doubt the map is precise enough to be of much use to them. We believe the benefits to the public easily outweigh the small potential downsides.

#### Is my data shared?

Absolutely not. We may publicly release some statistics about pins on the map, such as how many cameras have been marked in North America last month, but **we will never share personally identifying information.**

#### How can I help?

Spread the word! The strength of Where are the Eyes is in its community. The more users we have the more accurate the map becomes, and the more we can help change. 

Tell your friends and family! Post on message boards!

Print some [posters or fliers](/propaganda) and put them up on campus or at community centers or hackerspaces! Hack the planet!

## <a name="disclaimer"></a>Disclaimer

The camera information on our map is user-generated, and cannot be guaranteed to be complete or accurate. Please do not rely on this map for your safety. By using *Where are the Eyes* you acknowledge that the Daylighting Society and its staff are not responsible for your safety in any way, and that our software is provided with no warranty to the maximum extent permitted by law.

## About the Authors

The Daylighting Society is a non-profit organization dedicated to building technology that protects citizens' privacy and freedom. We are programmers, artists, and madmen involved in surveillance and security research. Read more on [the Daylighting Society homepage.](https://daylightingsociety.org)

## Contact

Questions? Feedback? Reach us at: [eyes@daylightingsociety.org](mailto:eyes@daylightingsociety.org)
