/*
 * Copyright (C) 2014 Eugeniy Meshcheryakov
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.debian.eugen.headingcalculator;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

/**
 * Class for buttons that show an explanation when long-clicked.
 */
@SuppressWarnings("WeakerAccess")
public class ExplainableButton extends Button {
    public ExplainableButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);

        setOnLongClickListener(new OnLongClickListener() {
            @Override
            public boolean onLongClick(View view) {
                CharSequence description = getContentDescription();
                if (description != null) {
                    Toast.makeText(getContext(), description, Toast.LENGTH_SHORT).show();
                }
                return true;
            }
        });
    }
}
