/*
 * Copyright (C) 2014 Lucien Loiseau
 *
 * This file is part of Rumble.
 *
 * Rumble is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Rumble is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Rumble.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.disrupted.rumble.network.protocols.command;

/**
 * @author Lucien Loiseau
 */
public abstract class Command {

    public enum CommandID {
        SEND_PUSH_STATUS,
        SEND_LOCAL_INFORMATION,
        SEND_CHAT_MESSAGE,
        SEND_KEEP_ALIVE
    }

    abstract public CommandID getCommandID();

    @Override
    public boolean equals(Object o) {
        if(o == null)
            return false;
        if(o instanceof Command) {
            Command command = (Command) o;
            return getCommandID().equals(command.getCommandID());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return getCommandID().hashCode();
    }
}
