package org.droidtr.keyboard;

import android.content.*;
import android.content.res.*;
import android.os.Build;
import android.graphics.*;
import android.graphics.drawable.*;
import android.inputmethodservice.*;
import android.view.*;
import android.view.View.*;
import android.widget.*;
import android.inputmethodservice.KeyboardView.OnKeyboardActionListener;
import android.provider.Settings ;
import android.net.Uri;
import org.droidtr.keyboard.*;
import org.droidtr.keyboard.CustomKeyboardView.key;
import android.view.inputmethod.EditorInfo;


//4299-4302 bosta
public class IME extends InputMethodService implements OnKeyboardActionListener {
	CustomKeyboardView main=null;
	LinearLayout emoji=null;
	RelativeLayout DroidTR=null;
	LinearLayout chatHead=null;
	RelativeLayout fallbackll=null;
	WindowManager windowManager=null;
	getSettings getSettings=null;
	View nav1,nav2;
	boolean lock=false,caps=false;
	boolean isInit;
	util u=null;
	public RelativeLayout getDroidTR(){
		RelativeLayout ll= new RelativeLayout(this);
		/*
  		Emoji arayuzu
  		Burada 3 fonksiyon bulunur. İlki emojilere basinca olusacak eylem icindir 
  		ikincisi silme tusunun eylemidir.
  		ucuncusu geri dönme tusu eylemidir.
  		*/
		emoji=new LinearLayout(this);
		emoji.setBackgroundColor(Color.WHITE);
		emoji.setOrientation(LinearLayout.VERTICAL);
		if(getSettings.isEmoji){
		emoji.addView((new emoji(this)).getEmoji(new OnClickListener() {

			@Override
			public void onClick(View p1) {
				if (p1 != null) {
					String emoticon = ((TextView) p1).getText().toString();
					getCurrentInputConnection().commitText(emoticon, 1);
					SharedPreferences read = getSharedPreferences("key", MODE_PRIVATE);
					SharedPreferences.Editor edit = read.edit();
					String[] lastemojis = read.getString("lastemojis", "").split(" ");
					String cache = emoticon;
					for (int i = 0; i < lastemojis.length; i++) {
						if (!lastemojis[i].equals(emoticon) && !lastemojis[i].equals("true") && !lastemojis[i].contains("@")) {
							cache = cache + " " + lastemojis[i];
						}
					}
					edit.putString("lastemojis", cache.trim());
					edit.commit();
				}
			}
		},new OnClickListener(){
			public void onClick(View p1){
				getCurrentInputConnection().sendKeyEvent(new KeyEvent(0, 0, KeyEvent.ACTION_DOWN,KeyEvent.KEYCODE_DEL, 0));
			}
		}, new OnClickListener() {

			@Override
			public void onClick(View p1) {
				emoji.setVisibility(View.GONE);
				main.setVisibility(View.VISIBLE);
				if(chatHead!=null){
					chatHead.setVisibility(View.VISIBLE);
				}
				main.setActiveKeyboard(0);
			}
		}));
		}
		emoji.setVisibility(View.GONE);
		/*
		Klavye motoru:
		Bu motor icin duzenler su kurallara göre olusturulur:
		1-her tus arasi bosluk birakilir
		2-\n alt satira gecme anlamina gelir.
		3-virgul isareti ile popup arayuzu karakterleri belirlenir.
		4-bosyuk yerine iki defa bosluk koyulur veya &b koyulur
		5-virgul yerine &v koyulur
		6-buyuk harfleri ele etmek icin motordaki UpperCase fonksiyonu kullanilir.
		string turundeki duzenler readData ile okutulur ve addrow ile eklenir.

		Her duzen icin buyuk ve kucuk harfler ayri olmak uzere ayri sayfalar bulunur
		bunlarin birer indis numarasi olur. 


		*/
		main = new CustomKeyboardView(this);
		main.bg=u.gd(getSettings.bg);//#1
		main.bgdown=u.gd(getSettings.bgdown);//#1
		main.bgon=u.gd(getSettings.bgon);//#1
		main.keyboardBackgroundDrawable=getSettings.keyboardBackgroundDrawable;//#1
		main.popupBackgroundDrawable=getSettings.popupBackgroundDrawable;//#1
		main.defaultButtonRadius=getSettings.defaultButtonRadius;//#1
		main.vibration=getSettings.vibration;//#1
		getSettings.loadKeys();//#1
		main.locale=getSettings.locale;//#1
		main.keyboardBackground=getSettings.keyboardBackground;//#1
		main.popupBackground=getSettings.popupBackground;//#1
		main.isAudioEffectEnabled=getSettings.isAudioEffectEnabled;//#1
		main.isVibrationEnabled=getSettings.isVibrationEnabled;//#1
		main.defaultButtonColor=getSettings.defaultButtonColor;//#1
		main.secondaryButtonColor=getSettings.secondaryButtonColor;//#1
		main.secondRowState=getSettings.secondRowState;//#1
		main.secondarySize=getSettings.secondarySize;
		main.primarySize=getSettings.primarySize;
		main.popupDuration=getSettings.popupDuration;
		main.repeatDuration=getSettings.repeatDuration;
		main.otobuyuk=getSettings.otobuyuk;
		if(getSettings.isTabView){
			main.addView(tabView());
		}
		main.createKeyboard(6);


		main.addrow(main.readData(getSettings.rows),0);
		main.addrow(main.UpperCase(main.readData(getSettings.rows)),1);
		main.addrow(main.readData(getSettings.sym),2);
		main.addrow(main.readData(getSettings.sym2),3);

		/*
		Bir tusa erisim icin getButton fonksiyonu kullanilir. 
		Bu fonksiyon koordinatlara göre calisir.
		getButton(sayfa,sira,eleman)
		sayfa numarasi negatif olamaz.
		sira numarasi negatif olursa asağidan yukari olarak sayar.
		eleman numarasi nefatif olursa sağdan sola sayar.

		eventler OnTouchListener olarak calisir. Tus uzerinde yazi varsa yazi 
		ekrana basilir yazi yoksa tus tagi keyevent olarak basilir.

		*/  

		//Gecisler
		main.getButton(1,-1,0).setOnTouchListener(main.setActiveKeyboardEvent(2));
		main.getButton(2,-1,0).setOnTouchListener(main.setActiveKeyboardEvent(0));
		main.getButton(0,-1,0).setOnTouchListener(main.setActiveKeyboardEvent(2));
		main.getButton(2,-2,0).setOnTouchListener(main.setActiveKeyboardEvent(3));
		main.getButton(3,-1,0).setOnTouchListener(main.setActiveKeyboardEvent(0));
		main.getButton(3,-2,0).setOnTouchListener(main.setActiveKeyboardEvent(2));

		if(getSettings.isShiftAvaiable){
			main.getButton(0,-2,0).setOnTouchListener(main.setActiveKeyboardEvent(1,true));
			main.getButton(1,-2,0).setOnTouchListener(main.setActiveKeyboardEvent(0,true));
		}

		//özel tuslar
		main.getButton(0,-2,-1).setTag(KeyEvent.KEYCODE_DEL);
		main.getButton(1,-2,-1).setTag(KeyEvent.KEYCODE_DEL);
		main.getButton(2,-2,-1).setTag(KeyEvent.KEYCODE_DEL);
		main.getButton(3,-2,-1).setTag(KeyEvent.KEYCODE_DEL);

		//Tekrarlama
		main.setRepeat(0,-2,-1);
		main.setRepeat(1,-2,-1);
		main.setRepeat(2,-2,-1);
		main.setRepeat(3,-2,-1);
		main.setRepeat(0,0,-1);
		main.setRepeat(1,0,-1);
		main.setRepeat(0,0,0);
		main.setRepeat(1,0,0);

		/*
		Temalandirma islemi
		10 farkli arkaplan drawable turunde tutulabilir.
		gd fonksiyonu ile gradient drawable olusturulabilir.
		coklu olarak tus temalandirmak icin int array array olusturulur.
		{{sayfa,sira,eleman,numara},{sayfa,sira,eleman,numara}}
		sayfa sira ve eleman getButton kurallarina tabidir.
		numara ise arkaplan numarasidir.
		Bellekte arkaplan tanimlanmamissa varsayilan değer döner.

		Motordaki bg nesnesi varsayilan tus arkaplanini ifade eder.
		klavye duzeni olusturmadan önce bg değiskeni duzenlenmelidir.(#1)
		Motordaki bgdown nesnesi tusa basarken değistirilecek arkaplandir.
		bg nesnesi gibi önceden ayarlanmalidir. (#1)
		Motordaki bgon nesnesi acilip kapanan tuslar etkin olduğunda
		değisecek arkaplandir. bg nesnesi gibi önceden ayarlanir. (#1)
		*/
		main.Backgrounds[1]= u.gd(getSettings.primaryButtonColors);
		main.Backgrounds[0] = u.gd(getSettings.secondaryButtonColors);

		int[][] cmds=new int[][]{{0,-1,-1,1},{1,-1,-1,1},{2,-1,-1,1},{3,-1,-1,1}};
		//Temalama
		main.setKeyBackground(cmds);
		cmds=new int[][]{{0,-1,0,0},{0,-1,1,0},{0,-1,2,0},{0,-1,-2,0},{0,-2,-1,0}};
		main.setKeyBackground(cmds);
		cmds=new int[][]{{1,-1,0,0},{1,-1,1,0},{1,-1,2,0},{1,-1,-2,0},{1,-2,-1,0}};
		main.setKeyBackground(cmds);
		cmds=new int[][]{{2,-2,0,0},{2,-1,0,0},{2,-1,1,0},{2,-1,2,0},{2,-1,3,0},{2,-1,-3,0},{2,-1,-2,0},{2,-2,-1,0}};
		main.setKeyBackground(cmds);
		cmds=new int[][]{{3,-2,0,0},{3,-1,0,0},{3,-1,1,0},{3,-1,2,0},{3,-1,3,0},{3,-1,-3,0},{3,-1,-2,0},{3,-2,-1,0}};
		main.setKeyBackground(cmds);
		main.setKeyBackground(cmds);
		//shift tusu arkaplani
		if(getSettings.isShiftAvaiable){
			cmds=new int[][]{{0,-2,0,0},{1,-2,0,0}};
			main.setKeyBackground(cmds);
		}
		/*
		Boyutlandirma islemi:
		W() genisliği H() ile yuksekliği belirtir.
		bu iki değeri oranlayarak genislik ve yukseklik ayarlayabilirsiniz.
		*/
		//bosluk tusu
		float bosluk = main.HW()/getSettings.heightFactor;
		main.getButton(0,-1,2).setLayoutParams(new LinearLayout.LayoutParams((int)(bosluk*((float)getSettings.spaceLength)/100f),-1));
		main.getButton(1,-1,2).setLayoutParams(new LinearLayout.LayoutParams((int)(bosluk*((float)getSettings.spaceLength)/100f),-1));
		main.getButton(2,-1,-4).setLayoutParams(new LinearLayout.LayoutParams((int)(bosluk*((float)getSettings.spaceLength)/135f),-1));
		main.getButton(3,-1,-4).setLayoutParams(new LinearLayout.LayoutParams((int)(bosluk*((float)getSettings.spaceLength)/135f),-1));
		/*
		Son islemler:
		setActiveKeyboard ile 0. sayfa etkin yapilmali
		init() calistirilmali. (#1 ayarlarini etkinlestirilyor.)
		sirasi ile klavyeyi, filler icine eklenmis popuplayoutu, emoji kutuphaneli
		eklenmeli.
		*/

		main.setActiveKeyboard(0);
		main.init();

		if(getSettings.isEmoji){
			//özel tuslarin simgesi
			main.getButton(2,-1,-1).setIcon(getResources().getDrawable(R.drawable.emo1));
		}else{
			main.getButton(2,-1,-1).setIcon(getResources().getDrawable(R.drawable.enter));
		}
		//delete tusu simgesi
		main.getButton(0,-2,-1).setIcon(getResources().getDrawable(R.drawable.del));
		main.getButton(1,-2,-1).setIcon(getResources().getDrawable(R.drawable.del));
		main.getButton(2,-2,-1).setIcon(getResources().getDrawable(R.drawable.del));
		main.getButton(3,-2,-1).setIcon(getResources().getDrawable(R.drawable.del));

		//enter tusu simgesi
		main.getButton(0,-1,-1).setIcon(getResources().getDrawable(R.drawable.enter));
		main.getButton(1,-1,-1).setIcon(getResources().getDrawable(R.drawable.enter));
		main.getButton(3,-1,-1).setIcon(getResources().getDrawable(R.drawable.enter));

		//tab tuşu
		main.getButton(2,-1,1).setIcon(getResources().getDrawable(R.drawable.tab));
		main.getButton(3,-1,1).setIcon(getResources().getDrawable(R.drawable.tab));

		//shift tusu simgesi
		if(getSettings.isShiftAvaiable){
			main.getButton(0,-2,0).setIcon(getResources().getDrawable(R.drawable.caps));
			main.getButton(1,-2,0).setIcon(getResources().getDrawable(R.drawable.caps));
		}
		main.getButton(2,-2,0).setIcon(getResources().getDrawable(R.drawable.caps));
		main.getButton(3,-2,0).setIcon(getResources().getDrawable(R.drawable.caps));

		//space tusu simgesi
		main.getButton(0,-1,-3).setIcon(getResources().getDrawable(R.drawable.space));
		main.getButton(1,-1,-3).setIcon(getResources().getDrawable(R.drawable.space));
		main.getButton(2,-1,-4).setIcon(getResources().getDrawable(R.drawable.space));
		main.getButton(3,-1,-4).setIcon(getResources().getDrawable(R.drawable.space));

		if(getSettings.isEmoji){
			main.getButton(2,-1,-1).setOnTouchListener(main.ViewVisible(emoji,main,chatHead));
		}
		//ok tuslari
		main.getButton(0,0,0).setIcon(getResources().getDrawable(R.drawable.sol));
		main.getButton(1,0,0).setIcon(getResources().getDrawable(R.drawable.sol));
		main.getButton(0,0,-1).setIcon(getResources().getDrawable(R.drawable.sag));
		main.getButton(1,0,-1).setIcon(getResources().getDrawable(R.drawable.sag));

		main.getButton(2,0,0).setIcon(getResources().getDrawable(R.drawable.sol));
		main.getButton(3,0,0).setIcon(getResources().getDrawable(R.drawable.sol));
		main.getButton(2,0,-1).setIcon(getResources().getDrawable(R.drawable.sag));
		main.getButton(3,0,-1).setIcon(getResources().getDrawable(R.drawable.sag));

		getWindow().getWindow().addFlags(WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED);
		if(getSettings.isNavbarEnable && !getSettings.isTablet){
			getWindow().getWindow().addFlags(WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS);
			nav1=main.getNavbarView();
			nav2=main.getNavbarView();
			main.addView(nav1);
			emoji.addView(nav2);
		}
		main.setHeight((int)(main.H()/getSettings.heightFactor));
		ll.addView(main);
		ll.addView(main.popuplayout(getResources().getDrawable(R.drawable.exit)));
		return ll;
	}
	LinearLayout tabView() {
		final String[] sym = ", . ? \" ' _ - + ; : | & ! \\ / * = % ~ # @ $ ` { } ( ) [ ] < >".split(" ");
		CustomKeyboardView.key[] t = new CustomKeyboardView.key[sym.length];
		LinearLayout lhs = new LinearLayout(this);
		LinearLayout lvl = new LinearLayout(this);
		HorizontalScrollView hsv = new HorizontalScrollView(this);
		LinearLayout ls = new LinearLayout(this);
		for (int i = 1; i != sym.length; i++) {
			final int j = i;
			t[i] = main.generateKey();
			t[i].setOnTouchListener(main.ocl);
			t[i].setLayoutParams(new LinearLayout.LayoutParams(((int)main.WH()/10),((int)main.WH()/10)));
			t[i].setLabel(sym[i]);
			ls.addView(t[i]);
		}
		lvl.addView(lhs);
		lhs.addView(hsv);
		hsv.addView(ls);
		return lvl;
	}
	@Override
	public void onWindowHidden(){
		main.setActiveKeyboard(0);
		main.setVisibility(View.GONE);
		if(chatHead!=null){
			chatHead.setVisibility(View.GONE);
		}
		System.gc();
	}


	@Override
	public void onWindowShown(){
		if (Build.VERSION.SDK_INT >= 23 && getSettings.isTablet) {
			if(!Settings.canDrawOverlays(this)){
				Intent myIntent = new Intent(Settings.ACTION_MANAGE_OVERLAY_PERMISSION,Uri.parse("package:" + getPackageName()));
				startActivity(myIntent);
				System.exit(0);
			}
		}
		emoji.setVisibility(View.GONE);
		main.setVisibility(View.VISIBLE);
		if(nav1 != null){
			nav1.setLayoutParams(new LinearLayout.LayoutParams(-1, main.getNavBarSize()));
		}
		if(nav2 != null){
			nav2.setLayoutParams(new LinearLayout.LayoutParams(-1, main.getNavBarSize()));
		}
		if(chatHead!=null){
			chatHead.setVisibility(View.VISIBLE);
		}
		System.gc();
		main.otobuyukevent();
	}
	@Override
	public View onCreateInputView(){
		getSettings = new getSettings(this);
		u=new util();
		chatHead = new LinearLayout(this);
		u.radius=getSettings.defaultButtonRadius;
		u.stroke=getSettings.defaultButtonStroke;
		DroidTR=getDroidTR();
		fallbackll=new RelativeLayout(this);
			if(getSettings.isTablet && isInit){
				System.exit(0);
			}
			if(getSettings.isTablet && !isInit){
				isInit=true;
				try{
					windowManager = (WindowManager) getSystemService(WINDOW_SERVICE);
					final WindowManager.LayoutParams params = new WindowManager.LayoutParams(
					WindowManager.LayoutParams.WRAP_CONTENT,
					WindowManager.LayoutParams.WRAP_CONTENT,
					WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY,
					WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE | WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED,
					PixelFormat.TRANSLUCENT);
					params.gravity = Gravity.CENTER;
					params.x = 0;
					params.y = 100;
					chatHead.setPadding(dpx(6),dpx(35),dpx(6),dpx(6));
					chatHead.setBackgroundDrawable(u.gd(getSettings.keyboardBackground));
					windowManager.addView(chatHead, params);
					chatHead.setOnTouchListener(new View.OnTouchListener() {
						private int initialX;
						private int initialY;
						private float initialTouchX;
						private float initialTouchY;

						@Override public boolean onTouch(View v, MotionEvent event) {
							switch (event.getAction()) {
								case MotionEvent.ACTION_DOWN:
								// Get current time in nano seconds.

								initialX = params.x;
								initialY = params.y;
								initialTouchX = event.getRawX();
								initialTouchY = event.getRawY();
								break;
								case MotionEvent.ACTION_UP:
								break;
								case MotionEvent.ACTION_MOVE:
								params.x = initialX + (int) (event.getRawX() - initialTouchX);
								params.y = initialY + (int) (event.getRawY() - initialTouchY);
								windowManager.updateViewLayout(chatHead, params);
								break;
							}
								return false;
						}
					});
					chatHead.addView(DroidTR);
					DroidTR.setLayoutParams(new LinearLayout.LayoutParams((int)(main.HW()/getSettings.heightFactor),(int)(main.HW()/(2*getSettings.heightFactor))));
				}catch(Exception e){
					fallbackll.addView(DroidTR);
				}
			}else{
				if(!getSettings.isTablet){
					fallbackll.addView(DroidTR);
				}
			}
			fallbackll.addView(emoji);
		return fallbackll;
	}
	@Override 
	public void onCreate() {
		super.onCreate();
		System.gc();
	}
	public void onStartInputView (EditorInfo info, boolean restarting){
		onStartInput(info,restarting);
	}
	public void onStartInput (EditorInfo info, boolean restarting){
		if(main!=null){
			main.actionId=info.imeOptions & (EditorInfo.IME_MASK_ACTION | EditorInfo.IME_FLAG_NO_ENTER_ACTION);
		}
	}

//KeyboardActionListener 
@Override
	public void swipeDown() {
	}

	@Override
	public void swipeLeft() {
	}

	@Override
	public void swipeRight() {
	}

	@Override
	public void swipeUp() {
	}
	public void onText(CharSequence p1) {
	}
	@Override
	public void onKey(int primaryCode, int[] keyCodes) {
	}

	@Override
	public void onRelease(int primaryCode) {
	}
	@Override
	public void onPress(int primaryCode) {
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if(getSettings!=null && main !=null){
			if (getSettings.butfunc && this.isInputViewShown() && this.isShowInputRequested()) {
				if (keyCode == KeyEvent.KEYCODE_VOLUME_UP) {
					main.ctrl=!main.ctrl;
					return true;
				}else if (keyCode == KeyEvent.KEYCODE_VOLUME_DOWN) {
					main.alt=!main.alt;
					return true;
				}
			}
		}
		return super.onKeyDown(keyCode, event);
	}

	public static float dp(float px){
		return Resources.getSystem().getDisplayMetrics().density * px;
	}
	public static int dpx(float px){
		return (int)(Resources.getSystem().getDisplayMetrics().density * px);
	}
}
