## よくある質問と答え

#### UniPatcher とは?

UniPatcher は、さまざまなビデオゲームコンソールの ROM イメージにパッチを適用するための Android ツールです。

#### サポートされているパッチ形式は?

アプリは IPS, IPS32, UPS, BPS, APS (GBA), APS (N64), PPF, DPS, EBP および XDelta3 パッチ形式をサポートしています。

#### このアプリを使用して Android のゲームをハックまたはクラックすることはできますか?

いいえ、UniPatcher は Android のゲームをハックするようには設計されていません。

#### ROM イメージとは?

ROM イメージは、ビデオゲームカートリッジのコピーを含むコンピューターファイルです。 エミュレーションのプロセスを通して、そのファイルをコピーし、 "エミュレーター" と呼ばれるソフトウェアで実行して、コンピューターや電話でゲームを楽しむことができます。

#### ROM ハックとは?

ROM ハックは ROM イメージのデータを変更します。 これは、グラフィックスの変更、ゲームレベルの変更、難易度の調整、またはゲームがもともと利用できなかった言語への翻訳の形をとることがあります。

#### パッチとは?

パッチは、元のバージョンの ROM とハックしたバージョンの違いを含むファイルです。

パッチが配布されると、エンドユーザーは元の ROM のコピーにパッチを適用し、プレー可能なバージョンのハックを生成します。

#### なぜ ROM のハッカーは変更されたゲームを配布しないのですか?

ダウンロードサイズを減らし、著作権の問題を避けるために、ハックや翻訳は一般にパッチとして配布されます。

#### ROM にパッチを適用する方法は?

ROM ファイルとパッチを選択して、赤い丸のボタンをタップする必要があります。

その結果、元の ROM と同じディレクトリーでパッチされた ROM を入手します。

#### ファイルを選択した後、アプリがメッセージを表示します: 「アーカイブは外部プログラムで解凍する必要があります」。

選択したファイルはアーカイブです。 アーカイブには、圧縮された形式のディレクトリーとファイルが含まれています。

現在、UniPatcher はアーカイブを抽出できないため、別のプログラムでアーカイブを解凍する必要があります。 私は無償のプログラムをお勧めします [ZArchiver](https://play.google.com/store/apps/details?id=ru.zdevs.zarchiver)。

#### エラーが表示されます: 「この ROM はパッチと互換性がありません」。

パッチに保存されているチェックサムが ROM のチェックサムと一致しない場合に、このエラーが表示されます。 つまり、ROM のファイルがパッチと互換性がありません。 別の ROM ファイルを選択する必要があります。 通常、それぞれのゲームにはいくつかの ROM があります (ヨーロッパ、アメリカ、日本向けのバージョン、良いものや不良のダンプなど)。

ROM のハッカーは、付随する ROM ファイルのチェックサムを (Web ページまたは README ファイルで) 公開することがよくあります。 それをお持ちのものと比較してください。 ファイルマネージャでファイルを長押しすると、CRC32、SHA1、MD5 の 3 行が表示されます。 それらの番号のうちの 1 つが同じ場合は、その ROM 用のパッチです。 そうでない場合は、別の ROM が必要です。

最悪の場合、正しいROMファイルを見つけられない場合は、設定で "チェックサムを無視する" オプションを設定することができます。 しかし、この場合、ゲームにバグが含まれてたり、完全にはプレイできない可能性があることにご注意ください。

#### ゲーム "ポケモンエメラルド" の正しい ROM を見つけることができません。

ゲームのパッチのほとんどは、ROM "ポケモン - エメラルドバージョン (U) \[f1\] (Save Type).gba" で動作します。

#### IPS パッチを適用した後、ゲームが動作しない / グラフィックの不具合があります。 何か間違っていますか?

IPS 形式のパッチにはチェックサムが含まれていません。 したがって、パッチはすべての (間違った) ROM ファイルにも適用されます。 この場合、別の ROM ファイルを探す必要があります。

#### .ECM ファイル形式で何ができますか?

ECM は、ディスクイメージ専用に設計されたデータ圧縮形式です。 次のプログラムを使用してファイルを解凍することができます [ZArchiver](https://play.google.com/store/apps/details?id=ru.zdevs.zarchiver) 。

#### アプリがエラーを表示します: 「ファイルをコピーできませんでした」。

このエラーは、一部の外部SDカードを搭載したAndroid 4.4以降のデバイスで発生します。 Androidは、アプリケーションでこれらのデバイスのSDカードにデータを書き込むことができません (詳細については [こちら](http://www.androidpolice.com/2014/02/17/external-blues-google-has-brought-big-changes-to-sd-cards-in-kitkat-and-even-samsung-may-be-implementing-them/))。

この問題を解決する方法はいくつかあります:

- 外部SDカードにあるROMファイルにパッチを適用しない。 ROMファイルをデバイスの内部メモリに移動するだけです。
- 出力ディレクトリとして、デバイスの内部メモリの任意のディレクトリへのパスを指定します (設定で)。
- 出力ディレクトリとして外部SDカードの **Android/data/org.emunix.unipatcher/** ディレクトリへのパスを指定します (設定で)。
- [SDFix](https://play.google.com/store/apps/details?id=nextapp.sdfix) アプリケーションをインストールします (ROOT アクセスが必要です)。

#### アプリがエラーを表示します: 「ファイルにパッチを当てた後、チェックサムが間違っています」。

プログラムのバグかもしれません。[e-mail](mailto:unipatcher@gmail.com) に連絡してください。 メールにパッチを添付してください。

#### UniPatcher には追加機能がありますか?

はい。 UniPatcher は次のことができます:

- XDelta3 パッチの作成。
- Sega Mega Drive / Sega Genesis ゲームのチェックサムの修正。
- Super Nintendo ゲームの SMC ヘッダーの追加または削除。

#### なぜ Sega Mega Drive ゲームのチェックサムを修正する必要があるのですか?

Sega Mega Drive (Genesis) のゲームは、チェックサムが ROM に書き込まれています。 ゲームの一部を変更するだけでは一致しないため、結果として実行されません。 行うことは、変更の正しいチェックサムを計算し、それを修正された ROM ファイルに書き込むことです。"

**警告:** この機能はバックアップ ROM を作成しません。

#### Super Nintendo ゲームから SMC ヘッダーを追加または削除する必要があるのはなぜですか?

SMC ヘッダーは、一部の SNES ROM イメージの先頭に 512 バイトあります。 これらのデータに目的はありませんが、残りのデータの位置は変更されます。 ヘッダーの削除や追加は、パッチを正しく適用するために使用されることがあります。

**警告:** この機能はバックアップ ROM を作成しません。

#### アプリを翻訳する方法は?

アプリを別の言語に翻訳したり、既存の翻訳を改善したい場合は [Transifex](https://www.transifex.com/unipatcher/unipatcher/dashboard/) サイトで行うことができます。

#### 質問、機能リクエスト、バグ報告があります。

メール <unipatcher@gmail.com> に私に連絡してください。 英語またはロシア語で記入してください。 パッチに問題がある場合は、パッチをメールに添付して ROM の名前を書いてください。これで時間を節約できます。