## Часто задаваемые вопросы:

#### Что такое UniPatcher?

Это приложение для Android предназначенное для наложения патчей на ROM файлы различных игровых видеоконсолей.

#### Какие форматы патчей поддерживаются?

Приложение поддерживает патчи в форматах IPS, IPS32, UPS, BPS, APS (GBA), APS (N64), PPF, DPS, EBP и XDelta3.

#### Возможно ли с помощью этого приложения взломать игру для Android?

Нет. Приложение не предназначено для взлома Android игр.

#### Что такое ROM файл?

ROM файл это компьютерный файл содержащий копию игрового картриджа. В процессе эмуляции вы запускаете этот файл с помощью программы эмулятора для того, чтобы наслаждаться игрой на вашем компьютере или телефоне.

#### Что такое ROM хакинг?

ROM хакинг это процесс модификации ROM файла с целью изменить графику, уровни, геймплей или язык игры.

#### Что такое патч?

Патч это файл содержащий разницу между оригинальной и изменённой версиями ROM'а.

Ромхакеры распространяют патч, а пользователи применяют этот патч к оригинальной версии ROM'а, тем самым получая модифицированную версию.

#### Почему ROM хакеры не распространяют пропатченные ROM файлы?

Хаки и переводы распространяются в виде патчей для того, что бы уменьшить размер скачиваемых данных и не нарушать авторские права на игру.

#### Как наложить патч на игру?

Вы должны выбрать ROM файл и патч, затем нажать на круглую красную кнопку с изображением дискеты

В результате вы получите пропатченый ROM, который будет находиться в одной директории с исходным ROM'ом.

#### Когда я выбираю файл приложение пишет "Архив необходимо распаковать во внешней программе".

Файл который вы выбрали является архивом. Архив содержит в себе директории и файлы в сжатом виде.

В настоящее время UniPatcher не умеет распаковывать архивы, поэтому вам необходимо распаковать свой архив в другой программе. Я рекомендую бесплатную программу [ZArchiver](https://play.google.com/store/apps/details?id=ru.zdevs.zarchiver).

#### Приложение пишет ошибку: "Этот ROM не совместим с патчем".

Эта ошибка появляется, когда контрольная сумма сохранённая в патче не совпадает с контрольной суммой ROM'а. Это означает, что данный ROM не совместим с патчем. Вам необходимо выбрать другой ROM. Обычно существует несколько версий ROM'а для каждой игры (например, версии для Европы, США, Японии, хорошие или плохие дампы и т.д.).

ROM-хакеры часто публикуют контрольную сумму необходимого ROM файла (на веб странице или в файле Readme). Вам необходимо сравнить её с вашим ROM'ом. Для этого в окне выбора файла сделайте долгий тап на ROM файле и вы увидите 3 строки: CRC32, SHA1 и MD5. Если одна из строк совпадает с контрольной суммой которую указал ROM-хакер, то у вас подходящий ROM. Если же не совпадает, то вам нужно поискать дугой ROM.

Если не удалось найти подходящий ROM, то в крайнем случае вы можете включить в настройках опцию "Игнорировать контрольную сумму". Но имейте ввиду, что в этом случае игра может содержать ошибки или быть полностью непроходимой.

#### Не могу подобрать ROM для игры "Pokémon Emerald".

Большинство патчей этой игры работают с ROM'ом "Pokemon - Emerald Version (U) \[f1\] (Save Type).gba".

#### Я применяю патч формата IPS к игре и после этого игра не работает/содержит графические артефакты. Что я делаю неправильно?

Патчи в формате IPS не содержат контрольной суммы. Поэтому, такой патч наложится на любой (даже неподходящий) ROM файл. В этом случае нужно использовать ROM другого региона.

#### Что можно сделать с файлом в формате .ECM?

ECM это формат сжатия данных созданный специально для образов дисков. Программа [ZArchiver](https://play.google.com/store/apps/details?id=ru.zdevs.zarchiver) умеет распаковывать этот формат.

#### Приложение пишет ошибку "Не удалось скопировать файл".

Эта ошибка появляется на некоторых устройствах с Android 4.4+ имеющих внешнюю карту памяти. На таких устройствах Andriod не позволяет приложениям записывать данные на карту памяти (подробнее о этом можно прочитать [здесь](http://www.androidpolice.com/2014/02/17/external-blues-google-has-brought-big-changes-to-sd-cards-in-kitkat-and-even-samsung-may-be-implementing-them/)).

Существует несколько способов решить эту проблему:

- Не применяйте патчи к ROM'ам находящимся на внешней карте памяти. Просто переместите ROM файл во внутреннюю память устройства.
- Укажите путь к любой директории во внутренней памяти устройства в качестве директории для сохранения (в настройках).
- Укажите путь к директории **Android/data/org.emunix.unipatcher/** навнешней карте памяти в качестве директории для сохранения (в настройках).
- Установить программу [SDFix](https://play.google.com/store/apps/details?id=nextapp.sdfix) (требуется ROOT).

#### Приложение пишет ошибку "Контрольная сумма пропатченного файла неправильная".

Возможен баг в моей программе. Пожалуйста, напишите мне на [e-mail](mailto:unipatcher@gmail.com) и прикрепите патч к письму.

#### Есть ли какие-то дополнительные функции?

Да. Приложение может:

- Создавать патчи в формате XDelta3.
- Исправлять контрольную сумму для игр Sega Mega Drive.
- Добавлять или удалять SMC заголовки для игр Super Nintendo.

#### Зачем исправлять контрольную сумму для игр Sega Mega Drive?

Некоторые игры Sega Mega Drive хранят внутри ROM'а контрольную сумму. Если вы измните любую часть игры, контрольные суммы не совпадут и игра не запустится (вы увидите красный экран вместо игры). Эта функция вычисляет и записывает корректную контрольную сумму в модифицированный ROM.

**Предупреждение:** эта функция не создаёт резервной копии ROM'а.

#### Зачем добавлять или удалять SMC заголовки в играх Super Nintendo?

SMC заголовок это 512 байт находящиеся в начале некоторых SNES ROM'ов. Эти байты не имеют значения, но они меняют расположение данных. Удаление или добавление заголовка иногда используется с целью корректного наложения патчей.

**Предупреждение:** эта функция не создаёт резервной копии ROM'а.

#### Как перевести приложение на другой язык?

Если вы хотите перевести приложение на другой язык или улучшить существующий перевод, вы можете сделать это на сайте [Transifex](https://www.transifex.com/unipatcher/unipatcher/dashboard/).

#### У меня есть вопрос, идея для новой функции или сообщение об ошибке.

Вы можете связаться со мной по электронной почте, мой адрес <unipatcher@gmail.com>. Прошу писать по-английски или по-русски. Если у вас проблема с наложением патча, то прикрепите патч к письму и напишите название вашего ROM'а, это сэкономит наше время.