/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.security.zipsigner;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import kellinwood.logging.LoggerInterface;
import kellinwood.logging.LoggerManager;

public class Base64 {
    static Method aEncodeMethod;
    static Method aDecodeMethod;
    static Object bEncoder;
    static Method bEncodeMethod;
    static Object bDecoder;
    static Method bDecodeMethod;
    static LoggerInterface logger;

    public static String encode(byte[] data) {
        try {
            if (aEncodeMethod != null) {
                byte[] encodedBytes = (byte[])aEncodeMethod.invoke(null, data, 2);
                return new String(encodedBytes);
            }
            if (bEncodeMethod != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                bEncodeMethod.invoke(bEncoder, data, 0, data.length, baos);
                return new String(baos.toByteArray());
            }
        }
        catch (Exception x) {
            throw new IllegalStateException(x.getClass().getName() + ": " + x.getMessage());
        }
        throw new IllegalStateException("No base64 encoder implementation is available.");
    }

    public static byte[] decode(byte[] data) {
        try {
            if (aDecodeMethod != null) {
                byte[] decodedBytes = (byte[])aDecodeMethod.invoke(null, data, 2);
                return decodedBytes;
            }
            if (bDecodeMethod != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                bDecodeMethod.invoke(bEncoder, data, 0, data.length, baos);
                return baos.toByteArray();
            }
        }
        catch (Exception x) {
            throw new IllegalStateException(x.getClass().getName() + ": " + x.getMessage());
        }
        throw new IllegalStateException("No base64 encoder implementation is available.");
    }

    static {
        Class<?> clazz;
        aEncodeMethod = null;
        aDecodeMethod = null;
        bEncoder = null;
        bEncodeMethod = null;
        bDecoder = null;
        bDecodeMethod = null;
        logger = null;
        logger = LoggerManager.getLogger(Base64.class.getName());
        try {
            clazz = Class.forName("android.util.Base64");
            aEncodeMethod = clazz.getMethod("encode", byte[].class, Integer.TYPE);
            aDecodeMethod = clazz.getMethod("decode", byte[].class, Integer.TYPE);
            logger.info(clazz.getName() + " is available.");
        }
        catch (ClassNotFoundException x) {
        }
        catch (Exception x) {
            logger.error("Failed to initialize use of android.util.Base64", x);
        }
        try {
            clazz = Class.forName("org.bouncycastle.util.encoders.Base64Encoder");
            bEncoder = clazz.newInstance();
            bEncodeMethod = clazz.getMethod("encode", byte[].class, Integer.TYPE, Integer.TYPE, OutputStream.class);
            logger.info(clazz.getName() + " is available.");
            bDecodeMethod = clazz.getMethod("decode", byte[].class, Integer.TYPE, Integer.TYPE, OutputStream.class);
        }
        catch (ClassNotFoundException x) {
        }
        catch (Exception x) {
            logger.error("Failed to initialize use of org.bouncycastle.util.encoders.Base64Encoder", x);
        }
        if (aEncodeMethod == null && bEncodeMethod == null) {
            throw new IllegalStateException("No base64 encoder implementation is available.");
        }
    }
}

