/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.security.zipsigner.optional;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.spec.SecretKeySpec;
import kellinwood.security.zipsigner.optional.LoadKeystoreException;

public class JKS
extends KeyStoreSpi {
    private static final int MAGIC = -17957139;
    private static final int PRIVATE_KEY = 1;
    private static final int TRUSTED_CERT = 2;
    private final Vector aliases = new Vector();
    private final HashMap trustedCerts = new HashMap();
    private final HashMap privateKeys = new HashMap();
    private final HashMap certChains = new HashMap();
    private final HashMap dates = new HashMap();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.privateKeys.containsKey(alias = alias.toLowerCase())) {
            return null;
        }
        byte[] key = JKS.decryptKey((byte[])this.privateKeys.get(alias), JKS.charsToBytes(password));
        Certificate[] chain = this.engineGetCertificateChain(alias);
        if (chain.length > 0) {
            try {
                KeyFactory fact = KeyFactory.getInstance(chain[0].getPublicKey().getAlgorithm());
                return fact.generatePrivate(new PKCS8EncodedKeySpec(key));
            }
            catch (InvalidKeySpecException x) {
                throw new UnrecoverableKeyException(x.getMessage());
            }
        }
        return new SecretKeySpec(key, alias);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        alias = alias.toLowerCase();
        return (Certificate[])this.certChains.get(alias);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Certificate[] certChain;
        if (this.engineIsKeyEntry(alias = alias.toLowerCase()) && (certChain = (Certificate[])this.certChains.get(alias)) != null && certChain.length > 0) {
            return certChain[0];
        }
        return (Certificate)this.trustedCerts.get(alias);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        alias = alias.toLowerCase();
        return (Date)this.dates.get(alias);
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] passwd, Certificate[] certChain) throws KeyStoreException {
        if (this.trustedCerts.containsKey(alias = alias.toLowerCase())) {
            throw new KeyStoreException("\"" + alias + " is a trusted certificate entry");
        }
        this.privateKeys.put(alias, JKS.encryptKey(key, JKS.charsToBytes(passwd)));
        if (certChain != null) {
            this.certChains.put(alias, certChain);
        } else {
            this.certChains.put(alias, new Certificate[0]);
        }
        if (!this.aliases.contains(alias)) {
            this.dates.put(alias, new Date());
            this.aliases.add(alias);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] encodedKey, Certificate[] certChain) throws KeyStoreException {
        if (this.trustedCerts.containsKey(alias = alias.toLowerCase())) {
            throw new KeyStoreException("\"" + alias + "\" is a trusted certificate entry");
        }
        try {
            new EncryptedPrivateKeyInfo(encodedKey);
        }
        catch (IOException ioe) {
            throw new KeyStoreException("encoded key is not an EncryptedPrivateKeyInfo");
        }
        this.privateKeys.put(alias, encodedKey);
        if (certChain != null) {
            this.certChains.put(alias, certChain);
        } else {
            this.certChains.put(alias, new Certificate[0]);
        }
        if (!this.aliases.contains(alias)) {
            this.dates.put(alias, new Date());
            this.aliases.add(alias);
        }
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (this.privateKeys.containsKey(alias = alias.toLowerCase())) {
            throw new KeyStoreException("\"" + alias + "\" is a private key entry");
        }
        if (cert == null) {
            throw new NullPointerException();
        }
        this.trustedCerts.put(alias, cert);
        if (!this.aliases.contains(alias)) {
            this.dates.put(alias, new Date());
            this.aliases.add(alias);
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        alias = alias.toLowerCase();
        this.aliases.remove(alias);
    }

    public Enumeration engineAliases() {
        return this.aliases.elements();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        alias = alias.toLowerCase();
        return this.aliases.contains(alias);
    }

    @Override
    public int engineSize() {
        return this.aliases.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        alias = alias.toLowerCase();
        return this.privateKeys.containsKey(alias);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        alias = alias.toLowerCase();
        return this.trustedCerts.containsKey(alias);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        for (String alias : this.trustedCerts.keySet()) {
            if (!cert.equals(this.trustedCerts.get(alias))) continue;
            return alias;
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream out, char[] passwd) throws IOException, NoSuchAlgorithmException, CertificateException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(JKS.charsToBytes(passwd));
        md.update("Mighty Aphrodite".getBytes("UTF-8"));
        DataOutputStream dout = new DataOutputStream(new DigestOutputStream(out, md));
        dout.writeInt(-17957139);
        dout.writeInt(2);
        dout.writeInt(this.aliases.size());
        Enumeration e = this.aliases.elements();
        while (e.hasMoreElements()) {
            String alias = (String)e.nextElement();
            if (this.trustedCerts.containsKey(alias)) {
                dout.writeInt(2);
                dout.writeUTF(alias);
                dout.writeLong(((Date)this.dates.get(alias)).getTime());
                JKS.writeCert(dout, (Certificate)this.trustedCerts.get(alias));
                continue;
            }
            dout.writeInt(1);
            dout.writeUTF(alias);
            dout.writeLong(((Date)this.dates.get(alias)).getTime());
            byte[] key = (byte[])this.privateKeys.get(alias);
            dout.writeInt(key.length);
            dout.write(key);
            Certificate[] chain = (Certificate[])this.certChains.get(alias);
            dout.writeInt(chain.length);
            for (int i = 0; i < chain.length; ++i) {
                JKS.writeCert(dout, chain[i]);
            }
        }
        byte[] digest = md.digest();
        dout.write(digest);
    }

    @Override
    public void engineLoad(InputStream in, char[] passwd) throws IOException, NoSuchAlgorithmException, CertificateException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        if (passwd != null) {
            md.update(JKS.charsToBytes(passwd));
        }
        md.update("Mighty Aphrodite".getBytes("UTF-8"));
        this.aliases.clear();
        this.trustedCerts.clear();
        this.privateKeys.clear();
        this.certChains.clear();
        this.dates.clear();
        if (in == null) {
            return;
        }
        DataInputStream din = new DataInputStream(new DigestInputStream(in, md));
        if (din.readInt() != -17957139) {
            throw new IOException("not a JavaKeyStore");
        }
        din.readInt();
        int n = din.readInt();
        this.aliases.ensureCapacity(n);
        if (n < 0) {
            throw new LoadKeystoreException("Malformed key store");
        }
        block4: for (int i = 0; i < n; ++i) {
            int type = din.readInt();
            String alias = din.readUTF();
            this.aliases.add(alias);
            this.dates.put(alias, new Date(din.readLong()));
            switch (type) {
                case 1: {
                    int len = din.readInt();
                    byte[] encoded = new byte[len];
                    din.read(encoded);
                    this.privateKeys.put(alias, encoded);
                    int count = din.readInt();
                    Certificate[] chain = new Certificate[count];
                    for (int j = 0; j < count; ++j) {
                        chain[j] = JKS.readCert(din);
                    }
                    this.certChains.put(alias, chain);
                    continue block4;
                }
                case 2: {
                    this.trustedCerts.put(alias, JKS.readCert(din));
                    continue block4;
                }
                default: {
                    throw new LoadKeystoreException("Malformed key store");
                }
            }
        }
        if (passwd != null) {
            byte[] computedHash = md.digest();
            byte[] storedHash = new byte[20];
            din.read(storedHash);
            if (!MessageDigest.isEqual(storedHash, computedHash)) {
                throw new LoadKeystoreException("Incorrect password, or integrity check failed.");
            }
        }
    }

    private static Certificate readCert(DataInputStream in) throws IOException, CertificateException, NoSuchAlgorithmException {
        String type = in.readUTF();
        int len = in.readInt();
        byte[] encoded = new byte[len];
        in.read(encoded);
        CertificateFactory factory = CertificateFactory.getInstance(type);
        return factory.generateCertificate(new ByteArrayInputStream(encoded));
    }

    private static void writeCert(DataOutputStream dout, Certificate cert) throws IOException, CertificateException {
        dout.writeUTF(cert.getType());
        byte[] b = cert.getEncoded();
        dout.writeInt(b.length);
        dout.write(b);
    }

    private static byte[] decryptKey(byte[] encryptedPKI, byte[] passwd) throws UnrecoverableKeyException {
        try {
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(encryptedPKI);
            byte[] encr = epki.getEncryptedData();
            byte[] keystream = new byte[20];
            System.arraycopy(encr, 0, keystream, 0, 20);
            byte[] check = new byte[20];
            System.arraycopy(encr, encr.length - 20, check, 0, 20);
            byte[] key = new byte[encr.length - 40];
            MessageDigest sha = MessageDigest.getInstance("SHA1");
            int count = 0;
            while (count < key.length) {
                sha.reset();
                sha.update(passwd);
                sha.update(keystream);
                sha.digest(keystream, 0, keystream.length);
                for (int i = 0; i < keystream.length && count < key.length; ++count, ++i) {
                    key[count] = (byte)(keystream[i] ^ encr[count + 20]);
                }
            }
            sha.reset();
            sha.update(passwd);
            sha.update(key);
            if (!MessageDigest.isEqual(check, sha.digest())) {
                throw new UnrecoverableKeyException("checksum mismatch");
            }
            return key;
        }
        catch (Exception x) {
            throw new UnrecoverableKeyException(x.getMessage());
        }
    }

    private static byte[] encryptKey(Key key, byte[] passwd) throws KeyStoreException {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA1");
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            byte[] k = key.getEncoded();
            byte[] encrypted = new byte[k.length + 40];
            byte[] keystream = SecureRandom.getSeed(20);
            System.arraycopy(keystream, 0, encrypted, 0, 20);
            int count = 0;
            while (count < k.length) {
                sha.reset();
                sha.update(passwd);
                sha.update(keystream);
                sha.digest(keystream, 0, keystream.length);
                for (int i = 0; i < keystream.length && count < k.length; ++count, ++i) {
                    encrypted[count + 20] = (byte)(keystream[i] ^ k[count]);
                }
            }
            sha.reset();
            sha.update(passwd);
            sha.update(k);
            sha.digest(encrypted, encrypted.length - 20, 20);
            return new EncryptedPrivateKeyInfo("1.3.6.1.4.1.42.2.17.1.1", encrypted).getEncoded();
        }
        catch (Exception x) {
            throw new KeyStoreException(x.getMessage());
        }
    }

    private static byte[] charsToBytes(char[] passwd) {
        byte[] buf = new byte[passwd.length * 2];
        int j = 0;
        for (int i = 0; i < passwd.length; ++i) {
            buf[j++] = (byte)(passwd[i] >>> 8);
            buf[j++] = (byte)passwd[i];
        }
        return buf;
    }
}

