/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.security.zipsigner;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kellinwood.logging.LoggerInterface;
import kellinwood.logging.LoggerManager;
import kellinwood.security.zipsigner.AutoKeyException;
import kellinwood.security.zipsigner.Base64;
import kellinwood.security.zipsigner.DefaultResourceAdapter;
import kellinwood.security.zipsigner.HexDumpEncoder;
import kellinwood.security.zipsigner.KeySet;
import kellinwood.security.zipsigner.ProgressHelper;
import kellinwood.security.zipsigner.ProgressListener;
import kellinwood.security.zipsigner.ResourceAdapter;
import kellinwood.security.zipsigner.ZipSignature;
import kellinwood.zipio.ZioEntry;
import kellinwood.zipio.ZipInput;
import kellinwood.zipio.ZipOutput;

public class ZipSigner {
    private boolean canceled = false;
    private ProgressHelper progressHelper = new ProgressHelper();
    private ResourceAdapter resourceAdapter = new DefaultResourceAdapter();
    static LoggerInterface log = null;
    private static final String CERT_SF_NAME = "META-INF/CERT.SF";
    private static final String CERT_RSA_NAME = "META-INF/CERT.RSA";
    private static Pattern stripPattern = Pattern.compile("^META-INF/(.*)[.](SF|RSA|DSA)$");
    Map<String, KeySet> loadedKeys = new HashMap<String, KeySet>();
    KeySet keySet = null;
    public static final String MODE_AUTO_TESTKEY = "auto-testkey";
    public static final String MODE_AUTO_NONE = "auto-none";
    public static final String MODE_AUTO = "auto";
    public static final String KEY_NONE = "none";
    public static final String KEY_TESTKEY = "testkey";
    public static final String[] SUPPORTED_KEY_MODES = new String[]{"auto-testkey", "auto", "auto-none", "media", "platform", "shared", "testkey", "none"};
    String keymode = "testkey";
    Map<String, String> autoKeyDetect = new HashMap<String, String>();
    AutoKeyObservable autoKeyObservable = new AutoKeyObservable();

    public static LoggerInterface getLogger() {
        if (log == null) {
            log = LoggerManager.getLogger(ZipSigner.class.getName());
        }
        return log;
    }

    public ZipSigner() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.autoKeyDetect.put("aa9852bc5a53272ac8031d49b65e4b0e", "media");
        this.autoKeyDetect.put("e60418c4b638f20d0721e115674ca11f", "platform");
        this.autoKeyDetect.put("3e24e49741b60c215c010dc6048fca7d", "shared");
        this.autoKeyDetect.put("dab2cead827ef5313f28e22b6fa8479f", KEY_TESTKEY);
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public void addAutoKeyObserver(Observer o) {
        this.autoKeyObservable.addObserver(o);
    }

    public String getKeymode() {
        return this.keymode;
    }

    public void setKeymode(String km) throws IOException, GeneralSecurityException {
        if (ZipSigner.getLogger().isDebugEnabled()) {
            ZipSigner.getLogger().debug("setKeymode: " + km);
        }
        this.keymode = km;
        if (this.keymode.startsWith(MODE_AUTO)) {
            this.keySet = null;
        } else {
            this.progressHelper.initProgress();
            this.loadKeys(this.keymode);
        }
    }

    public static String[] getSupportedKeyModes() {
        return SUPPORTED_KEY_MODES;
    }

    protected String autoDetectKey(String mode, Map<String, ZioEntry> zioEntries) throws NoSuchAlgorithmException, IOException {
        boolean debug = ZipSigner.getLogger().isDebugEnabled();
        if (!mode.startsWith(MODE_AUTO)) {
            return mode;
        }
        String keyName = null;
        for (Map.Entry<String, ZioEntry> entry : zioEntries.entrySet()) {
            String entryName = entry.getKey();
            if (!entryName.startsWith("META-INF/") || !entryName.endsWith(".RSA")) continue;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] entryData = entry.getValue().getData();
            if (entryData.length < 1458) break;
            md5.update(entryData, 0, 1458);
            byte[] rawDigest = md5.digest();
            StringBuilder builder = new StringBuilder();
            for (byte b : rawDigest) {
                builder.append(String.format("%02x", b));
            }
            String md5String = builder.toString();
            keyName = this.autoKeyDetect.get(md5String);
            if (debug) {
                if (keyName != null) {
                    ZipSigner.getLogger().debug(String.format("Auto-determined key=%s using md5=%s", keyName, md5String));
                } else {
                    ZipSigner.getLogger().debug(String.format("Auto key determination failed for md5=%s", md5String));
                }
            }
            if (keyName == null) continue;
            return keyName;
        }
        if (mode.equals(MODE_AUTO_TESTKEY)) {
            if (debug) {
                ZipSigner.getLogger().debug("Falling back to key=" + keyName);
            }
            return KEY_TESTKEY;
        }
        if (mode.equals(MODE_AUTO_NONE)) {
            if (debug) {
                ZipSigner.getLogger().debug("Unable to determine key, returning: none");
            }
            return KEY_NONE;
        }
        return null;
    }

    public void issueLoadingCertAndKeysProgressEvent() {
        this.progressHelper.progress(1, this.resourceAdapter.getString(ResourceAdapter.Item.LOADING_CERTIFICATE_AND_KEY, new Object[0]));
    }

    public void loadKeys(String name) throws IOException, GeneralSecurityException {
        this.keySet = this.loadedKeys.get(name);
        if (this.keySet != null) {
            return;
        }
        this.keySet = new KeySet();
        this.keySet.setName(name);
        this.loadedKeys.put(name, this.keySet);
        if (KEY_NONE.equals(name)) {
            return;
        }
        this.issueLoadingCertAndKeysProgressEvent();
        URL privateKeyUrl = this.getClass().getResource("/keys/" + name + ".pk8");
        this.keySet.setPrivateKey(this.readPrivateKey(privateKeyUrl, null));
        URL publicKeyUrl = this.getClass().getResource("/keys/" + name + ".x509.pem");
        this.keySet.setPublicKey(this.readPublicKey(publicKeyUrl));
        URL sigBlockTemplateUrl = this.getClass().getResource("/keys/" + name + ".sbt");
        if (sigBlockTemplateUrl != null) {
            this.keySet.setSigBlockTemplate(this.readContentAsBytes(sigBlockTemplateUrl));
        }
    }

    public void setKeys(String name, X509Certificate publicKey, PrivateKey privateKey, byte[] signatureBlockTemplate) {
        this.keySet = new KeySet(name, publicKey, privateKey, signatureBlockTemplate);
    }

    public void setKeys(String name, X509Certificate publicKey, PrivateKey privateKey, String signatureAlgorithm, byte[] signatureBlockTemplate) {
        this.keySet = new KeySet(name, publicKey, privateKey, signatureAlgorithm, signatureBlockTemplate);
    }

    public KeySet getKeySet() {
        return this.keySet;
    }

    public void cancel() {
        this.canceled = true;
    }

    public void resetCanceled() {
        this.canceled = false;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void loadProvider(String providerClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> providerClass = Class.forName(providerClassName);
        Provider provider = (Provider)providerClass.newInstance();
        Security.insertProviderAt(provider, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate readPublicKey(URL publicKeyUrl) throws IOException, GeneralSecurityException {
        try (InputStream input = publicKeyUrl.openStream();){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(input);
            return x509Certificate;
        }
    }

    private KeySpec decryptPrivateKey(byte[] encryptedPrivateKey, String keyPassword) throws GeneralSecurityException {
        EncryptedPrivateKeyInfo epkInfo;
        try {
            epkInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKey);
        }
        catch (IOException ex) {
            return null;
        }
        char[] keyPasswd = keyPassword.toCharArray();
        SecretKeyFactory skFactory = SecretKeyFactory.getInstance(epkInfo.getAlgName());
        SecretKey key = skFactory.generateSecret(new PBEKeySpec(keyPasswd));
        Cipher cipher = Cipher.getInstance(epkInfo.getAlgName());
        cipher.init(2, (Key)key, epkInfo.getAlgParameters());
        try {
            return epkInfo.getKeySpec(cipher);
        }
        catch (InvalidKeySpecException ex) {
            ZipSigner.getLogger().error("signapk: Password for private key may be bad.");
            throw ex;
        }
    }

    public byte[] readContentAsBytes(URL contentUrl) throws IOException {
        return this.readContentAsBytes(contentUrl.openStream());
    }

    public byte[] readContentAsBytes(InputStream input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int numRead = input.read(buffer);
        while (numRead != -1) {
            baos.write(buffer, 0, numRead);
            numRead = input.read(buffer);
        }
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey readPrivateKey(URL privateKeyUrl, String keyPassword) throws IOException, GeneralSecurityException {
        try (DataInputStream input = new DataInputStream(privateKeyUrl.openStream());){
            byte[] bytes = this.readContentAsBytes(input);
            KeySpec spec = this.decryptPrivateKey(bytes, keyPassword);
            if (spec == null) {
                spec = new PKCS8EncodedKeySpec(bytes);
            }
            try {
                PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(spec);
                return privateKey;
            }
            catch (InvalidKeySpecException ex) {
                PrivateKey privateKey = KeyFactory.getInstance("DSA").generatePrivate(spec);
                input.close();
                return privateKey;
            }
        }
    }

    private Manifest addDigestsToManifest(Map<String, ZioEntry> entries) throws IOException, GeneralSecurityException {
        Manifest input = null;
        ZioEntry manifestEntry = entries.get("META-INF/MANIFEST.MF");
        if (manifestEntry != null) {
            InputStream is = manifestEntry.getInputStream();
            input = new Manifest();
            input.read(is);
            is.close();
        }
        Manifest output = new Manifest();
        Attributes main = output.getMainAttributes();
        if (input != null) {
            main.putAll((Map<?, ?>)input.getMainAttributes());
        } else {
            main.putValue("Manifest-Version", "1.0");
            main.putValue("Created-By", "1.0 (Android SignApk)");
        }
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] buffer = new byte[512];
        TreeMap<String, ZioEntry> byName = new TreeMap<String, ZioEntry>();
        byName.putAll(entries);
        boolean debug = ZipSigner.getLogger().isDebugEnabled();
        if (debug) {
            ZipSigner.getLogger().debug("Manifest entries:");
        }
        for (ZioEntry entry : byName.values()) {
            Attributes inAttr;
            int num;
            if (this.canceled) break;
            String name = entry.getName();
            if (debug) {
                ZipSigner.getLogger().debug(name);
            }
            if (entry.isDirectory() || name.equals("META-INF/MANIFEST.MF") || name.equals(CERT_SF_NAME) || name.equals(CERT_RSA_NAME) || stripPattern != null && stripPattern.matcher(name).matches()) continue;
            this.progressHelper.progress(0, this.resourceAdapter.getString(ResourceAdapter.Item.GENERATING_MANIFEST, new Object[0]));
            InputStream data = entry.getInputStream();
            while ((num = data.read(buffer)) > 0) {
                md.update(buffer, 0, num);
            }
            Attributes attr = null;
            if (input != null && (inAttr = input.getAttributes(name)) != null) {
                attr = new Attributes(inAttr);
            }
            if (attr == null) {
                attr = new Attributes();
            }
            attr.putValue("SHA1-Digest", Base64.encode(md.digest()));
            output.getEntries().put(name, attr);
        }
        return output;
    }

    private void generateSignatureFile(Manifest manifest, OutputStream out) throws IOException, GeneralSecurityException {
        out.write("Signature-Version: 1.0\r\n".getBytes());
        out.write("Created-By: 1.0 (Android SignApk)\r\n".getBytes());
        MessageDigest md = MessageDigest.getInstance("SHA1");
        PrintStream print = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), md), true, "UTF-8");
        manifest.write(print);
        print.flush();
        out.write(("SHA1-Digest-Manifest: " + Base64.encode(md.digest()) + "\r\n\r\n").getBytes());
        Map<String, Attributes> entries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            if (this.canceled) break;
            this.progressHelper.progress(0, this.resourceAdapter.getString(ResourceAdapter.Item.GENERATING_SIGNATURE_FILE, new Object[0]));
            String nameEntry = "Name: " + entry.getKey() + "\r\n";
            print.print(nameEntry);
            for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                print.print(att.getKey() + ": " + att.getValue() + "\r\n");
            }
            print.print("\r\n");
            print.flush();
            out.write(nameEntry.getBytes());
            out.write(("SHA1-Digest: " + Base64.encode(md.digest()) + "\r\n\r\n").getBytes());
        }
    }

    private void writeSignatureBlock(KeySet keySet, byte[] signatureFileBytes, OutputStream out) throws IOException, GeneralSecurityException {
        if (keySet.getSigBlockTemplate() != null) {
            ZipSignature signature = new ZipSignature();
            signature.initSign(keySet.getPrivateKey());
            signature.update(signatureFileBytes);
            byte[] signatureBytes = signature.sign();
            out.write(keySet.getSigBlockTemplate());
            out.write(signatureBytes);
            if (ZipSigner.getLogger().isDebugEnabled()) {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update(signatureFileBytes);
                byte[] sfDigest = md.digest();
                ZipSigner.getLogger().debug("Sig File SHA1: \n" + HexDumpEncoder.encode(sfDigest));
                ZipSigner.getLogger().debug("Signature: \n" + HexDumpEncoder.encode(signatureBytes));
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(2, keySet.getPublicKey());
                byte[] tmpData = cipher.doFinal(signatureBytes);
                ZipSigner.getLogger().debug("Signature Decrypted: \n" + HexDumpEncoder.encode(tmpData));
            }
        } else {
            try {
                byte[] sigBlock = null;
                Class<?> generatorClass = Class.forName("kellinwood.security.zipsigner.optional.SignatureBlockGenerator");
                Method generatorMethod = generatorClass.getMethod("generate", KeySet.class, new byte[1].getClass());
                sigBlock = (byte[])generatorMethod.invoke(null, keySet, signatureFileBytes);
                out.write(sigBlock);
            }
            catch (Exception x) {
                throw new RuntimeException(x.getMessage(), x);
            }
        }
    }

    private void copyFiles(Manifest manifest, Map<String, ZioEntry> input, ZipOutput output, long timestamp) throws IOException {
        Map<String, Attributes> entries = manifest.getEntries();
        ArrayList<String> names = new ArrayList<String>(entries.keySet());
        Collections.sort(names);
        int i = 1;
        for (String name : names) {
            if (this.canceled) break;
            this.progressHelper.progress(0, this.resourceAdapter.getString(ResourceAdapter.Item.COPYING_ZIP_ENTRY, i, names.size()));
            ++i;
            ZioEntry inEntry = input.get(name);
            inEntry.setTime(timestamp);
            output.write(inEntry);
        }
    }

    private void copyFiles(Map<String, ZioEntry> input, ZipOutput output) throws IOException {
        int i = 1;
        for (ZioEntry inEntry : input.values()) {
            if (this.canceled) break;
            this.progressHelper.progress(0, this.resourceAdapter.getString(ResourceAdapter.Item.COPYING_ZIP_ENTRY, i, input.size()));
            ++i;
            output.write(inEntry);
        }
    }

    public void signZip(URL keystoreURL, String keystoreType, String keystorePw, String certAlias, String certPw, String inputZipFilename, String outputZipFilename) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException, GeneralSecurityException {
        this.signZip(keystoreURL, keystoreType, keystorePw.toCharArray(), certAlias, certPw.toCharArray(), "SHA1withRSA", inputZipFilename, outputZipFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signZip(URL keystoreURL, String keystoreType, char[] keystorePw, String certAlias, char[] certPw, String signatureAlgorithm, String inputZipFilename, String outputZipFilename) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException, GeneralSecurityException {
        try (InputStream keystoreStream = null;){
            KeyStore keystore = null;
            if (keystoreType == null) {
                keystoreType = KeyStore.getDefaultType();
            }
            keystore = KeyStore.getInstance(keystoreType);
            keystoreStream = keystoreURL.openStream();
            keystore.load(keystoreStream, keystorePw);
            Certificate cert = keystore.getCertificate(certAlias);
            X509Certificate publicKey = (X509Certificate)cert;
            Key key = keystore.getKey(certAlias, certPw);
            PrivateKey privateKey = (PrivateKey)key;
            this.setKeys("custom", publicKey, privateKey, signatureAlgorithm, null);
            this.signZip(inputZipFilename, outputZipFilename);
        }
    }

    public void signZip(Map<String, ZioEntry> zioEntries, String outputZipFilename) throws IOException, GeneralSecurityException {
        this.progressHelper.initProgress();
        this.signZip(zioEntries, new FileOutputStream(outputZipFilename), outputZipFilename);
    }

    public void signZip(String inputZipFilename, String outputZipFilename) throws IOException, GeneralSecurityException {
        File outFile;
        File inFile = new File(inputZipFilename).getCanonicalFile();
        if (inFile.equals(outFile = new File(outputZipFilename).getCanonicalFile())) {
            throw new IllegalArgumentException(this.resourceAdapter.getString(ResourceAdapter.Item.INPUT_SAME_AS_OUTPUT_ERROR, new Object[0]));
        }
        this.progressHelper.initProgress();
        this.progressHelper.progress(1, this.resourceAdapter.getString(ResourceAdapter.Item.PARSING_CENTRAL_DIRECTORY, new Object[0]));
        ZipInput input = ZipInput.read(inputZipFilename);
        this.signZip(input.getEntries(), new FileOutputStream(outputZipFilename), outputZipFilename);
        input.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signZip(Map<String, ZioEntry> zioEntries, OutputStream outputStream, String outputZipFilename) throws IOException, GeneralSecurityException {
        boolean debug = ZipSigner.getLogger().isDebugEnabled();
        this.progressHelper.initProgress();
        if (this.keySet == null) {
            if (!this.keymode.startsWith(MODE_AUTO)) {
                throw new IllegalStateException("No keys configured for signing the file!");
            }
            String keyName = this.autoDetectKey(this.keymode, zioEntries);
            if (keyName == null) {
                throw new AutoKeyException(this.resourceAdapter.getString(ResourceAdapter.Item.AUTO_KEY_SELECTION_ERROR, new File(outputZipFilename).getName()));
            }
            this.autoKeyObservable.notifyObservers(keyName);
            this.loadKeys(keyName);
        }
        ZipOutput zipOutput = null;
        try {
            zipOutput = new ZipOutput(outputStream);
            if (KEY_NONE.equals(this.keySet.getName())) {
                this.progressHelper.setProgressTotalItems(zioEntries.size());
                this.progressHelper.setProgressCurrentItem(0);
                this.copyFiles(zioEntries, zipOutput);
                return;
            }
            int progressTotalItems = 0;
            for (ZioEntry entry : zioEntries.values()) {
                String name = entry.getName();
                if (entry.isDirectory() || name.equals("META-INF/MANIFEST.MF") || name.equals(CERT_SF_NAME) || name.equals(CERT_RSA_NAME) || stripPattern != null && stripPattern.matcher(name).matches()) continue;
                progressTotalItems += 3;
            }
            this.progressHelper.setProgressTotalItems(++progressTotalItems);
            this.progressHelper.setProgressCurrentItem(0);
            long timestamp = this.keySet.getPublicKey().getNotBefore().getTime() + 3600000L;
            Manifest manifest = this.addDigestsToManifest(zioEntries);
            if (this.canceled) {
                return;
            }
            ZioEntry ze = new ZioEntry("META-INF/MANIFEST.MF");
            ze.setTime(timestamp);
            manifest.write(ze.getOutputStream());
            zipOutput.write(ze);
            ze = new ZioEntry(CERT_SF_NAME);
            ze.setTime(timestamp);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.generateSignatureFile(manifest, out);
            if (this.canceled) {
                return;
            }
            byte[] sfBytes = out.toByteArray();
            if (debug) {
                ZipSigner.getLogger().debug("Signature File: \n" + new String(sfBytes) + "\n" + HexDumpEncoder.encode(sfBytes));
            }
            ze.getOutputStream().write(sfBytes);
            zipOutput.write(ze);
            this.progressHelper.progress(0, this.resourceAdapter.getString(ResourceAdapter.Item.GENERATING_SIGNATURE_BLOCK, new Object[0]));
            ze = new ZioEntry(CERT_RSA_NAME);
            ze.setTime(timestamp);
            this.writeSignatureBlock(this.keySet, sfBytes, ze.getOutputStream());
            zipOutput.write(ze);
            if (this.canceled) {
                return;
            }
            this.copyFiles(manifest, zioEntries, zipOutput, timestamp);
            if (this.canceled) {
                return;
            }
        }
        finally {
            zipOutput.close();
            if (this.canceled) {
                try {
                    if (outputZipFilename != null) {
                        new File(outputZipFilename).delete();
                    }
                }
                catch (Throwable t) {
                    ZipSigner.getLogger().warning(t.getClass().getName() + ":" + t.getMessage());
                }
            }
        }
    }

    public void addProgressListener(ProgressListener l) {
        this.progressHelper.addProgressListener(l);
    }

    public synchronized void removeProgressListener(ProgressListener l) {
        this.progressHelper.removeProgressListener(l);
    }

    public static class AutoKeyObservable
    extends Observable {
        @Override
        public void notifyObservers(Object arg) {
            super.setChanged();
            super.notifyObservers(arg);
        }
    }
}

