/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.security.zipsigner.optional;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.x500.style.BCStyle;
import org.spongycastle.jce.X509Principal;

public class DistinguishedNameValues
extends LinkedHashMap<ASN1ObjectIdentifier, String> {
    public DistinguishedNameValues() {
        this.put(BCStyle.C, null);
        this.put(BCStyle.ST, null);
        this.put(BCStyle.L, null);
        this.put(BCStyle.STREET, null);
        this.put(BCStyle.O, null);
        this.put(BCStyle.OU, null);
        this.put(BCStyle.CN, null);
    }

    @Override
    public String put(ASN1ObjectIdentifier oid, String value) {
        if (value != null && value.equals("")) {
            value = null;
        }
        if (this.containsKey(oid)) {
            super.put(oid, value);
        } else {
            super.put(oid, value);
        }
        return value;
    }

    public void setCountry(String country) {
        this.put(BCStyle.C, country);
    }

    public void setState(String state) {
        this.put(BCStyle.ST, state);
    }

    public void setLocality(String locality) {
        this.put(BCStyle.L, locality);
    }

    public void setStreet(String street) {
        this.put(BCStyle.STREET, street);
    }

    public void setOrganization(String organization) {
        this.put(BCStyle.O, organization);
    }

    public void setOrganizationalUnit(String organizationalUnit) {
        this.put(BCStyle.OU, organizationalUnit);
    }

    public void setCommonName(String commonName) {
        this.put(BCStyle.CN, commonName);
    }

    @Override
    public int size() {
        int result = 0;
        for (String value : this.values()) {
            if (value == null) continue;
            ++result;
        }
        return result;
    }

    public X509Principal getPrincipal() {
        Vector oids = new Vector();
        Vector values = new Vector();
        for (Map.Entry entry : this.entrySet()) {
            if (entry.getValue() == null || ((String)entry.getValue()).equals("")) continue;
            oids.add(entry.getKey());
            values.add(entry.getValue());
        }
        return new X509Principal(oids, values);
    }
}

