/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import org.apache.james.mime4j.io.BufferedLineReaderInputStream;
import org.apache.james.mime4j.io.LineReaderInputStream;
import org.apache.james.mime4j.util.ByteArrayBuffer;

public class MimeBoundaryInputStream
extends LineReaderInputStream {
    private final byte[] boundary;
    private boolean eof;
    private int limit;
    private boolean atBoundary;
    private int boundaryLen;
    private boolean lastPart;
    private boolean completed;
    private BufferedLineReaderInputStream buffer;
    private int initialLength;

    public MimeBoundaryInputStream(BufferedLineReaderInputStream inbuffer, String boundary) throws IOException {
        super(inbuffer);
        if (inbuffer.capacity() < boundary.length() * 2) {
            throw new IllegalArgumentException("Boundary is too long");
        }
        this.buffer = inbuffer;
        this.eof = false;
        this.limit = -1;
        this.atBoundary = false;
        this.boundaryLen = 0;
        this.lastPart = false;
        this.initialLength = -1;
        this.completed = false;
        this.boundary = new byte[boundary.length() + 2];
        this.boundary[0] = 45;
        this.boundary[1] = 45;
        for (int i = 0; i < boundary.length(); ++i) {
            byte ch = (byte)boundary.charAt(i);
            if (ch == 13 || ch == 10) {
                throw new IllegalArgumentException("Boundary may not contain CR or LF");
            }
            this.boundary[i + 2] = ch;
        }
        this.fillBuffer();
    }

    public void close() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public boolean readAllowed() throws IOException {
        if (this.completed) {
            return false;
        }
        if (this.endOfStream() && !this.hasData()) {
            this.skipBoundary();
            return false;
        }
        return true;
    }

    public int read() throws IOException {
        if (!this.readAllowed()) {
            return -1;
        }
        while (!this.hasData()) {
            if (this.endOfStream()) {
                this.skipBoundary();
                return -1;
            }
            this.fillBuffer();
        }
        return this.buffer.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.readAllowed()) {
            return -1;
        }
        this.fillBuffer();
        if (!this.hasData()) {
            return this.read(b, off, len);
        }
        int chunk = Math.min(len, this.limit - this.buffer.pos());
        return this.buffer.read(b, off, chunk);
    }

    public int readLine(ByteArrayBuffer dst) throws IOException {
        if (dst == null) {
            throw new IllegalArgumentException("Destination buffer may not be null");
        }
        if (!this.readAllowed()) {
            return -1;
        }
        int total = 0;
        boolean found = false;
        int bytesRead = 0;
        while (!found) {
            int chunk;
            if (!this.hasData()) {
                bytesRead = this.fillBuffer();
                if (this.endOfStream() && !this.hasData()) {
                    this.skipBoundary();
                    bytesRead = -1;
                    break;
                }
            }
            int len = this.limit - this.buffer.pos();
            int i = this.buffer.indexOf((byte)10, this.buffer.pos(), len);
            if (i != -1) {
                found = true;
                chunk = i + 1 - this.buffer.pos();
            } else {
                chunk = len;
            }
            if (chunk <= 0) continue;
            dst.append(this.buffer.buf(), this.buffer.pos(), chunk);
            this.buffer.skip(chunk);
            total += chunk;
        }
        if (total == 0 && bytesRead == -1) {
            return -1;
        }
        return total;
    }

    private boolean endOfStream() {
        return this.eof || this.atBoundary;
    }

    private boolean hasData() {
        return this.limit > this.buffer.pos() && this.limit <= this.buffer.limit();
    }

    private int fillBuffer() throws IOException {
        int bytesRead;
        if (this.eof) {
            return -1;
        }
        if (!this.hasData()) {
            bytesRead = this.buffer.fillBuffer();
            if (bytesRead == -1) {
                this.eof = true;
            }
        } else {
            bytesRead = 0;
        }
        int i = this.buffer.indexOf(this.boundary);
        while (i > this.buffer.pos() && this.buffer.charAt(i - 1) != 10) {
            i += this.boundary.length;
            i = this.buffer.indexOf(this.boundary, i, this.buffer.limit() - i);
        }
        if (i != -1) {
            this.limit = i;
            this.atBoundary = true;
            this.calculateBoundaryLen();
        } else {
            this.limit = this.eof ? this.buffer.limit() : this.buffer.limit() - (this.boundary.length + 1);
        }
        return bytesRead;
    }

    public boolean isEmptyStream() {
        return this.initialLength == 0;
    }

    private void calculateBoundaryLen() throws IOException {
        this.boundaryLen = this.boundary.length;
        int len = this.limit - this.buffer.pos();
        if (len >= 0 && this.initialLength == -1) {
            this.initialLength = len;
        }
        if (len > 0 && this.buffer.charAt(this.limit - 1) == 10) {
            ++this.boundaryLen;
            --this.limit;
        }
        if (len > 1 && this.buffer.charAt(this.limit - 1) == 13) {
            ++this.boundaryLen;
            --this.limit;
        }
    }

    private void skipBoundary() throws IOException {
        if (!this.completed) {
            this.completed = true;
            this.buffer.skip(this.boundaryLen);
            boolean checkForLastPart = true;
            while (true) {
                if (this.buffer.length() > 1) {
                    byte ch1 = this.buffer.charAt(this.buffer.pos());
                    byte ch2 = this.buffer.charAt(this.buffer.pos() + 1);
                    if (checkForLastPart && ch1 == 45 && ch2 == 45) {
                        this.lastPart = true;
                        this.buffer.skip(2);
                        checkForLastPart = false;
                        continue;
                    }
                    if (ch1 == 13 && ch2 == 10) {
                        this.buffer.skip(2);
                        break;
                    }
                    if (ch1 == 10) {
                        this.buffer.skip(1);
                        break;
                    }
                    this.buffer.skip(1);
                    continue;
                }
                if (this.eof) break;
                this.fillBuffer();
            }
        }
    }

    public boolean isLastPart() {
        return this.lastPart;
    }

    public boolean eof() {
        return this.eof && !this.buffer.hasBufferedData();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("MimeBoundaryInputStream, boundary ");
        for (byte b : this.boundary) {
            buffer.append((char)b);
        }
        return buffer.toString();
    }

    public boolean unread(ByteArrayBuffer buf) {
        return false;
    }
}

