/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.MimeEntityConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.MutableBodyDescriptorFactory;
import org.apache.james.mime4j.stream.RawField;

public class MimeStreamParser {
    private ContentHandler handler = null;
    private boolean contentDecoding;
    private final MimeEntityConfig mimeEntityConfig;
    private final MimeTokenStream mimeTokenStream;

    public MimeStreamParser(MimeTokenStream tokenStream) {
        this.mimeTokenStream = tokenStream;
        this.mimeEntityConfig = tokenStream.getConfig();
        this.contentDecoding = false;
    }

    public MimeStreamParser(MimeEntityConfig config, boolean clone, MutableBodyDescriptorFactory bodyDescFactory, DecodeMonitor monitor) {
        this(new MimeTokenStream(clone ? config.clone() : config, bodyDescFactory, monitor));
    }

    public MimeStreamParser(MimeEntityConfig config, boolean clone) {
        this(new MimeTokenStream(clone ? config.clone() : config, null, null));
    }

    public MimeStreamParser(MimeEntityConfig config, MutableBodyDescriptorFactory bodyDescFactory, DecodeMonitor monitor) {
        this(config != null ? config : new MimeEntityConfig(), config != null, bodyDescFactory, monitor);
    }

    public MimeStreamParser(MimeEntityConfig config) {
        this(config, null, null);
    }

    public MimeStreamParser() {
        this(new MimeEntityConfig(), false, null, null);
    }

    public boolean isContentDecoding() {
        return this.contentDecoding;
    }

    public void setContentDecoding(boolean b) {
        this.contentDecoding = b;
    }

    public void parse(InputStream inputStream) throws MimeException, IOException {
        if (this.mimeEntityConfig.getHeadlessParsing() != null) {
            this.mimeTokenStream.parseHeadless(inputStream, this.mimeEntityConfig.getHeadlessParsing());
            this.handler.startMessage();
            this.handler.startHeader();
            this.handler.field(new RawField("Content-Type", this.mimeEntityConfig.getHeadlessParsing()));
            this.handler.endHeader();
        } else {
            this.mimeTokenStream.parse(inputStream);
        }
        block16: while (true) {
            int state = this.mimeTokenStream.getState();
            switch (state) {
                case 12: {
                    BodyDescriptor desc = this.mimeTokenStream.getBodyDescriptor();
                    InputStream bodyContent = this.contentDecoding ? this.mimeTokenStream.getDecodedInputStream() : this.mimeTokenStream.getInputStream();
                    this.handler.body(desc, bodyContent);
                    break;
                }
                case 11: {
                    this.handler.endBodyPart();
                    break;
                }
                case 5: {
                    this.handler.endHeader();
                    break;
                }
                case 1: {
                    this.handler.endMessage();
                    break;
                }
                case 7: {
                    this.handler.endMultipart();
                    break;
                }
                case -1: {
                    break block16;
                }
                case 9: {
                    this.handler.epilogue(this.mimeTokenStream.getInputStream());
                    break;
                }
                case 4: {
                    this.handler.field(this.mimeTokenStream.getField());
                    break;
                }
                case 8: {
                    this.handler.preamble(this.mimeTokenStream.getInputStream());
                    break;
                }
                case 2: {
                    this.handler.raw(this.mimeTokenStream.getInputStream());
                    break;
                }
                case 10: {
                    this.handler.startBodyPart();
                    break;
                }
                case 3: {
                    this.handler.startHeader();
                    break;
                }
                case 0: {
                    this.handler.startMessage();
                    break;
                }
                case 6: {
                    this.handler.startMultipart(this.mimeTokenStream.getBodyDescriptor());
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid state: " + state);
                }
            }
            int n = this.mimeTokenStream.next();
        }
    }

    public boolean isRaw() {
        return this.mimeTokenStream.isRaw();
    }

    public void setRaw(boolean raw) {
        this.mimeTokenStream.setRecursionMode(2);
    }

    public void setFlat(boolean flat) {
        this.mimeTokenStream.setRecursionMode(3);
    }

    public void stop() {
        this.mimeTokenStream.stop();
    }

    public void setContentHandler(ContentHandler h) {
        this.handler = h;
    }
}

