/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.IOException;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.io.LineReaderInputStream;
import org.apache.james.mime4j.io.MaxHeaderLengthLimitException;
import org.apache.james.mime4j.io.MaxHeaderLimitException;
import org.apache.james.mime4j.io.MaxLineLimitException;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.EntityStateMachine;
import org.apache.james.mime4j.stream.Event;
import org.apache.james.mime4j.stream.MimeEntityConfig;
import org.apache.james.mime4j.stream.MimeParseEventException;
import org.apache.james.mime4j.stream.MutableBodyDescriptor;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.ByteArrayBuffer;

public abstract class AbstractEntity
implements EntityStateMachine {
    protected final int startState;
    protected final int endState;
    protected final MimeEntityConfig config;
    protected final MutableBodyDescriptor body;
    protected int state;
    private final ByteArrayBuffer linebuf;
    private int lineCount;
    private RawField field;
    private boolean endOfHeader;
    private int headerCount;
    protected final DecodeMonitor monitor;
    private static final int T_IN_BODYPART = -2;
    private static final int T_IN_MESSAGE = -3;

    AbstractEntity(MutableBodyDescriptor body, int startState, int endState, MimeEntityConfig config, DecodeMonitor monitor) {
        this.state = startState;
        this.startState = startState;
        this.endState = endState;
        this.config = config;
        this.body = body;
        this.linebuf = new ByteArrayBuffer(64);
        this.lineCount = 0;
        this.endOfHeader = false;
        this.headerCount = 0;
        this.monitor = monitor;
    }

    public int getState() {
        return this.state;
    }

    protected abstract int getLineNumber();

    protected abstract LineReaderInputStream getDataStream();

    private ByteArrayBuffer fillFieldBuffer() throws IOException, MimeException {
        if (this.endOfHeader) {
            throw new IllegalStateException();
        }
        int maxHeaderLen = this.config.getMaxHeaderLen();
        LineReaderInputStream instream = this.getDataStream();
        ByteArrayBuffer fieldbuf = new ByteArrayBuffer(64);
        try {
            byte ch;
            do {
                int len = this.linebuf.length();
                if (maxHeaderLen > 0 && fieldbuf.length() + len >= maxHeaderLen) {
                    throw new MaxHeaderLengthLimitException("Maximum header length limit exceeded");
                }
                if (len > 0) {
                    fieldbuf.append(this.linebuf.buffer(), 0, len);
                }
                this.linebuf.clear();
                if (instream.readLine(this.linebuf) == -1) {
                    this.monitor(Event.HEADERS_PREMATURE_END);
                    this.endOfHeader = true;
                    break;
                }
                len = this.linebuf.length();
                if (len > 0 && this.linebuf.byteAt(len - 1) == 10) {
                    --len;
                }
                if (len > 0 && this.linebuf.byteAt(len - 1) == 13) {
                    --len;
                }
                if (len == 0) {
                    this.endOfHeader = true;
                    break;
                }
                ++this.lineCount;
            } while (this.lineCount <= 1 || (ch = this.linebuf.byteAt(0)) == 32 || ch == 9);
        }
        catch (MaxLineLimitException e) {
            throw new MimeException(e);
        }
        return fieldbuf;
    }

    protected boolean parseField() throws MimeException, IOException {
        int maxHeaderCount = this.config.getMaxHeaderCount();
        while (!this.endOfHeader) {
            if (maxHeaderCount > 0 && this.headerCount >= maxHeaderCount) {
                throw new MaxHeaderLimitException("Maximum header limit exceeded");
            }
            ByteArrayBuffer fieldbuf = this.fillFieldBuffer();
            ++this.headerCount;
            int origLen = fieldbuf.length();
            int len = fieldbuf.length();
            if (len > 0 && fieldbuf.byteAt(len - 1) == 10) {
                --len;
            }
            if (len > 0 && fieldbuf.byteAt(len - 1) == 13) {
                --len;
            }
            fieldbuf.setLength(len);
            try {
                this.field = new RawField(fieldbuf);
                if (this.field.isObsoleteSyntax()) {
                    this.monitor(Event.OBSOLETE_HEADER);
                }
                this.body.addField(this.field);
                return true;
            }
            catch (MimeException e) {
                this.monitor(Event.INVALID_HEADER);
                if (!this.config.isMalformedHeaderStartsBody()) continue;
                fieldbuf.setLength(origLen);
                LineReaderInputStream instream = this.getDataStream();
                if (!instream.unread(fieldbuf)) {
                    throw new MimeParseEventException(Event.INVALID_HEADER);
                }
                return false;
            }
            break;
        }
        return false;
    }

    public BodyDescriptor getBodyDescriptor() {
        switch (this.getState()) {
            case -1: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                return this.body;
            }
        }
        throw new IllegalStateException("Invalid state :" + AbstractEntity.stateToString(this.state));
    }

    public RawField getField() {
        switch (this.getState()) {
            case 4: {
                return this.field;
            }
        }
        throw new IllegalStateException("Invalid state :" + AbstractEntity.stateToString(this.state));
    }

    protected void monitor(Event event) throws MimeException, IOException {
        String message;
        if (this.monitor.isListening() && this.monitor.warn(message = this.message(event), "ignoring")) {
            throw new MimeParseEventException(event);
        }
    }

    protected String message(Event event) {
        String message = event == null ? "Event is unexpectedly null." : event.toString();
        int lineNumber = this.getLineNumber();
        if (lineNumber <= 0) {
            return message;
        }
        return "Line " + lineNumber + ": " + message;
    }

    public String toString() {
        return this.getClass().getName() + " [" + AbstractEntity.stateToString(this.state) + "][" + this.body.getMimeType() + "][" + this.body.getBoundary() + "]";
    }

    public static final String stateToString(int state) {
        String result;
        switch (state) {
            case -1: {
                result = "End of stream";
                break;
            }
            case 0: {
                result = "Start message";
                break;
            }
            case 1: {
                result = "End message";
                break;
            }
            case 2: {
                result = "Raw entity";
                break;
            }
            case 3: {
                result = "Start header";
                break;
            }
            case 4: {
                result = "Field";
                break;
            }
            case 5: {
                result = "End header";
                break;
            }
            case 6: {
                result = "Start multipart";
                break;
            }
            case 7: {
                result = "End multipart";
                break;
            }
            case 8: {
                result = "Preamble";
                break;
            }
            case 9: {
                result = "Epilogue";
                break;
            }
            case 10: {
                result = "Start bodypart";
                break;
            }
            case 11: {
                result = "End bodypart";
                break;
            }
            case 12: {
                result = "Body";
                break;
            }
            case -2: {
                result = "Bodypart";
                break;
            }
            case -3: {
                result = "In message";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return result;
    }
}

