/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.util.HashMap;
import java.util.Map;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.MutableBodyDescriptor;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.MimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBodyDescriptor
implements MutableBodyDescriptor {
    private static final String US_ASCII = "us-ascii";
    private static final String SUB_TYPE_EMAIL = "rfc822";
    private static final String MEDIA_TYPE_TEXT = "text";
    private static final String MEDIA_TYPE_MESSAGE = "message";
    private static final String EMAIL_MESSAGE_MIME_TYPE = "message/rfc822";
    private static final String DEFAULT_SUB_TYPE = "plain";
    private static final String DEFAULT_MEDIA_TYPE = "text";
    private static final String DEFAULT_MIME_TYPE = "text/plain";
    private final DecodeMonitor monitor;
    private String mediaType = "text";
    private String subType = "plain";
    private String mimeType = "text/plain";
    private String boundary = null;
    private String charset = "us-ascii";
    private String transferEncoding = "7bit";
    private Map<String, String> parameters = new HashMap<String, String>();
    private boolean contentTypeSet;
    private boolean contentTransferEncSet;
    private long contentLength = -1L;

    public DefaultBodyDescriptor() {
        this(null, null);
    }

    public DefaultBodyDescriptor(BodyDescriptor parent, DecodeMonitor monitor) {
        if (parent != null && MimeUtil.isSameMimeType("multipart/digest", parent.getMimeType())) {
            this.mimeType = EMAIL_MESSAGE_MIME_TYPE;
            this.subType = SUB_TYPE_EMAIL;
            this.mediaType = MEDIA_TYPE_MESSAGE;
        } else {
            this.mimeType = DEFAULT_MIME_TYPE;
            this.subType = DEFAULT_SUB_TYPE;
            this.mediaType = "text";
        }
        this.monitor = monitor != null ? monitor : DecodeMonitor.SILENT;
    }

    protected DecodeMonitor getDecodeMonitor() {
        return this.monitor;
    }

    @Override
    public MutableBodyDescriptor newChild() {
        return new DefaultBodyDescriptor(this, this.getDecodeMonitor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addField(RawField field) throws MimeException {
        String name = field.getName();
        String value = field.getBody();
        if ((name = name.trim().toLowerCase()).equals("content-transfer-encoding") && !this.contentTransferEncSet) {
            this.contentTransferEncSet = true;
            if ((value = value.trim().toLowerCase()).length() <= 0) return;
            this.transferEncoding = value;
            return;
        } else if (name.equals("content-length") && this.contentLength == -1L) {
            try {
                this.contentLength = Long.parseLong(value.trim());
                return;
            }
            catch (NumberFormatException e) {
                if (!this.monitor.warn("Invalid content length: " + value, "ignoring Content-Length header")) return;
                throw new MimeException("Invalid Content-Length header: " + value);
            }
        } else {
            if (!name.equals("content-type") || this.contentTypeSet) return;
            this.parseContentType(value);
        }
    }

    private void parseContentType(String value) throws MimeException {
        this.contentTypeSet = true;
        Map<String, String> params = DefaultBodyDescriptor.getHeaderParams(value, this.getDecodeMonitor());
        String main = params.get("");
        String type = null;
        String subtype = null;
        if (main != null) {
            main = main.toLowerCase().trim();
            int index = main.indexOf(47);
            boolean valid = false;
            if (index != -1) {
                type = main.substring(0, index).trim();
                subtype = main.substring(index + 1).trim();
                if (type.length() > 0 && subtype.length() > 0) {
                    main = type + "/" + subtype;
                    valid = true;
                }
            }
            if (!valid) {
                main = null;
                type = null;
                subtype = null;
            }
        }
        String b = params.get("boundary");
        if (main != null && (main.startsWith("multipart/") && b != null || !main.startsWith("multipart/"))) {
            this.mimeType = main;
            this.subType = subtype;
            this.mediaType = type;
        }
        if (MimeUtil.isMultipart(this.mimeType)) {
            this.boundary = b;
        }
        String c = params.get("charset");
        this.charset = null;
        if (c != null && (c = c.trim()).length() > 0) {
            this.charset = c.toLowerCase();
        }
        if (this.charset == null && "text".equals(this.mediaType)) {
            this.charset = US_ASCII;
        }
        this.parameters.putAll(params);
        this.parameters.remove("");
        this.parameters.remove("boundary");
        this.parameters.remove("charset");
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getBoundary() {
        return this.boundary;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public Map<String, String> getContentTypeParameters() {
        return this.parameters;
    }

    @Override
    public String getTransferEncoding() {
        return this.transferEncoding;
    }

    public String toString() {
        return this.mimeType;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    public static Map<String, String> getHeaderParams(String pValue, DecodeMonitor monitor) throws MimeException {
        String rest;
        String main;
        pValue = pValue.trim();
        HashMap<String, String> result = new HashMap<String, String>();
        if (pValue.indexOf(";") == -1) {
            main = pValue;
            rest = null;
        } else {
            main = pValue.substring(0, pValue.indexOf(";"));
            rest = pValue.substring(main.length() + 1);
        }
        result.put("", main);
        if (rest != null) {
            char[] chars = rest.toCharArray();
            StringBuilder paramName = new StringBuilder(64);
            StringBuilder paramValue = new StringBuilder(64);
            boolean READY_FOR_NAME = false;
            boolean IN_NAME = true;
            int READY_FOR_VALUE = 2;
            int IN_VALUE = 3;
            int IN_QUOTED_VALUE = 4;
            int VALUE_DONE = 5;
            int ERROR = 99;
            int state = 0;
            boolean escaped = false;
            block24: for (char c : chars) {
                switch (state) {
                    case 99: {
                        if (c != ';') continue block24;
                        state = 0;
                        continue block24;
                    }
                    case 0: {
                        if (c == '=') {
                            if (monitor.warn("Expected header param name, got '='", "ignoring")) {
                                throw new MimeException("Expected header param name, got '='");
                            }
                            state = 99;
                            continue block24;
                        }
                        paramName.setLength(0);
                        paramValue.setLength(0);
                        state = 1;
                    }
                    case 1: {
                        if (c == '=') {
                            if (paramName.length() == 0) {
                                state = 99;
                                continue block24;
                            }
                            state = 2;
                            continue block24;
                        }
                        paramName.append(c);
                        continue block24;
                    }
                    case 2: {
                        boolean fallThrough = false;
                        switch (c) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case '\"': {
                                state = 4;
                                break;
                            }
                            default: {
                                state = 3;
                                fallThrough = true;
                            }
                        }
                        if (!fallThrough) continue block24;
                    }
                    case 3: {
                        boolean fallThrough = false;
                        switch (c) {
                            case '\t': 
                            case ' ': 
                            case ';': {
                                result.put(paramName.toString().trim().toLowerCase(), paramValue.toString().trim());
                                state = 5;
                                fallThrough = true;
                                break;
                            }
                            default: {
                                paramValue.append(c);
                            }
                        }
                        if (!fallThrough) continue block24;
                    }
                    case 5: {
                        switch (c) {
                            case ';': {
                                state = 0;
                                continue block24;
                            }
                            case '\t': 
                            case ' ': {
                                continue block24;
                            }
                        }
                        state = 99;
                        continue block24;
                    }
                    case 4: {
                        switch (c) {
                            case '\"': {
                                if (!escaped) {
                                    result.put(paramName.toString().trim().toLowerCase(), paramValue.toString());
                                    state = 5;
                                    continue block24;
                                }
                                escaped = false;
                                paramValue.append(c);
                                continue block24;
                            }
                            case '\\': {
                                if (escaped) {
                                    paramValue.append('\\');
                                }
                                escaped = !escaped;
                                continue block24;
                            }
                        }
                        if (escaped) {
                            paramValue.append('\\');
                        }
                        escaped = false;
                        paramValue.append(c);
                    }
                }
            }
            if (state == 3) {
                result.put(paramName.toString().trim().toLowerCase(), paramValue.toString().trim());
            }
        }
        return result;
    }
}

