/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.io.BufferedLineReaderInputStream;
import org.apache.james.mime4j.io.LimitedInputStream;
import org.apache.james.mime4j.io.LineNumberSource;
import org.apache.james.mime4j.io.LineReaderInputStream;
import org.apache.james.mime4j.io.LineReaderInputStreamAdaptor;
import org.apache.james.mime4j.io.MimeBoundaryInputStream;
import org.apache.james.mime4j.stream.AbstractEntity;
import org.apache.james.mime4j.stream.EntityStateMachine;
import org.apache.james.mime4j.stream.Event;
import org.apache.james.mime4j.stream.MimeEntityConfig;
import org.apache.james.mime4j.stream.MutableBodyDescriptor;
import org.apache.james.mime4j.stream.RawEntity;
import org.apache.james.mime4j.util.MimeUtil;

public class MimeEntity
extends AbstractEntity {
    private final LineNumberSource lineSource;
    private final BufferedLineReaderInputStream inbuffer;
    private int recursionMode;
    private MimeBoundaryInputStream currentMimePartStream;
    private LineReaderInputStreamAdaptor dataStream;
    private byte[] tmpbuf;

    public MimeEntity(LineNumberSource lineSource, InputStream instream, MutableBodyDescriptor body, int startState, int endState, MimeEntityConfig config, DecodeMonitor monitor) {
        super(body, startState, endState, config, monitor);
        this.lineSource = lineSource;
        this.inbuffer = new BufferedLineReaderInputStream(instream, 4096, config.getMaxLineLen());
        this.dataStream = new LineReaderInputStreamAdaptor(this.inbuffer, config.getMaxLineLen());
    }

    public MimeEntity(LineNumberSource lineSource, InputStream instream, MutableBodyDescriptor body, int startState, int endState, MimeEntityConfig config) {
        this(lineSource, instream, body, startState, endState, config, config.isStrictParsing() ? DecodeMonitor.STRICT : DecodeMonitor.SILENT);
    }

    public MimeEntity(LineNumberSource lineSource, InputStream instream, MutableBodyDescriptor body) {
        this(lineSource, instream, body, 0, 1, new MimeEntityConfig(), DecodeMonitor.SILENT);
    }

    public int getRecursionMode() {
        return this.recursionMode;
    }

    public void setRecursionMode(int recursionMode) {
        this.recursionMode = recursionMode;
    }

    public void stop() {
        this.inbuffer.truncate();
    }

    protected int getLineNumber() {
        if (this.lineSource == null) {
            return -1;
        }
        return this.lineSource.getLineNumber();
    }

    protected LineReaderInputStream getDataStream() {
        return this.dataStream;
    }

    public EntityStateMachine advance() throws IOException, MimeException {
        switch (this.state) {
            case 0: {
                this.state = 3;
                break;
            }
            case 10: {
                this.state = 3;
                break;
            }
            case 3: 
            case 4: {
                this.state = this.parseField() ? 4 : 5;
                break;
            }
            case 5: {
                String mimeType = this.body.getMimeType();
                if (this.recursionMode == 3) {
                    this.state = 12;
                    break;
                }
                if (MimeUtil.isMultipart(mimeType)) {
                    this.state = 6;
                    this.clearMimePartStream();
                    break;
                }
                if (this.recursionMode != 1 && MimeUtil.isMessage(mimeType)) {
                    this.state = 12;
                    return this.nextMessage();
                }
                this.state = 12;
                break;
            }
            case 6: {
                if (this.dataStream.isUsed()) {
                    this.advanceToBoundary();
                    this.state = 7;
                    break;
                }
                this.createMimePartStream();
                this.state = 8;
                if (!this.currentMimePartStream.isEmptyStream()) break;
            }
            case 8: {
                this.advanceToBoundary();
                if (this.currentMimePartStream.eof() && !this.currentMimePartStream.isLastPart()) {
                    this.monitor(Event.MIME_BODY_PREMATURE_END);
                } else if (!this.currentMimePartStream.isLastPart()) {
                    this.clearMimePartStream();
                    this.createMimePartStream();
                    return this.nextMimeEntity();
                }
                this.clearMimePartStream();
                this.state = 9;
                break;
            }
            case 9: {
                this.state = 7;
                break;
            }
            case 7: 
            case 12: {
                this.state = this.endState;
                break;
            }
            default: {
                if (this.state == this.endState) {
                    this.state = -1;
                    break;
                }
                throw new IllegalStateException("Invalid state: " + MimeEntity.stateToString(this.state));
            }
        }
        return null;
    }

    private void createMimePartStream() throws MimeException, IOException {
        String boundary = this.body.getBoundary();
        int bufferSize = 2 * boundary.length();
        if (bufferSize < 4096) {
            bufferSize = 4096;
        }
        try {
            this.inbuffer.ensureCapacity(bufferSize);
            this.currentMimePartStream = new MimeBoundaryInputStream(this.inbuffer, boundary);
        }
        catch (IllegalArgumentException e) {
            throw new MimeException(e.getMessage(), e);
        }
        this.dataStream = new LineReaderInputStreamAdaptor(this.currentMimePartStream, this.config.getMaxLineLen());
    }

    private void clearMimePartStream() {
        this.currentMimePartStream = null;
        this.dataStream = new LineReaderInputStreamAdaptor(this.inbuffer, this.config.getMaxLineLen());
    }

    private void advanceToBoundary() throws IOException {
        if (!this.dataStream.eof()) {
            if (this.tmpbuf == null) {
                this.tmpbuf = new byte[2048];
            }
            InputStream instream = this.getLimitedContentStream();
            while (instream.read(this.tmpbuf) != -1) {
            }
        }
    }

    private EntityStateMachine nextMessage() {
        InputStream instream = this.currentMimePartStream != null ? this.currentMimePartStream : this.inbuffer;
        instream = this.decodedStream(instream);
        return this.nextMimeEntity(0, 1, instream);
    }

    private InputStream decodedStream(InputStream instream) {
        String transferEncoding = this.body.getTransferEncoding();
        if (MimeUtil.isBase64Encoding(transferEncoding)) {
            instream = new Base64InputStream(instream, this.monitor);
        } else if (MimeUtil.isQuotedPrintableEncoded(transferEncoding)) {
            instream = new QuotedPrintableInputStream(instream, this.monitor);
        }
        return instream;
    }

    private EntityStateMachine nextMimeEntity() {
        return this.nextMimeEntity(10, 11, this.currentMimePartStream);
    }

    private EntityStateMachine nextMimeEntity(int startState, int endState, InputStream instream) {
        if (this.recursionMode == 2) {
            RawEntity message = new RawEntity(instream);
            return message;
        }
        MimeEntity mimeentity = new MimeEntity(this.lineSource, instream, this.body.newChild(), startState, endState, this.config, this.monitor);
        mimeentity.setRecursionMode(this.recursionMode);
        return mimeentity;
    }

    private InputStream getLimitedContentStream() {
        long maxContentLimit = this.config.getMaxContentLen();
        if (maxContentLimit >= 0L) {
            return new LimitedInputStream(this.dataStream, maxContentLimit);
        }
        return this.dataStream;
    }

    public InputStream getContentStream() {
        switch (this.state) {
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                return this.getLimitedContentStream();
            }
        }
        throw new IllegalStateException("Invalid state: " + MimeEntity.stateToString(this.state));
    }

    public InputStream getDecodedContentStream() throws IllegalStateException {
        return this.decodedStream(this.getContentStream());
    }
}

