/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.io.LineNumberInputStream;
import org.apache.james.mime4j.stream.AbstractEntity;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.DefaultBodyDescriptor;
import org.apache.james.mime4j.stream.EntityStateMachine;
import org.apache.james.mime4j.stream.EntityStates;
import org.apache.james.mime4j.stream.MimeEntity;
import org.apache.james.mime4j.stream.MimeEntityConfig;
import org.apache.james.mime4j.stream.MutableBodyDescriptor;
import org.apache.james.mime4j.stream.MutableBodyDescriptorFactory;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.stream.RecursionMode;
import org.apache.james.mime4j.util.CharsetUtil;

public class MimeTokenStream
implements EntityStates,
RecursionMode {
    private final MimeEntityConfig config;
    private final DecodeMonitor monitor;
    private final MutableBodyDescriptorFactory bodyDescFactory;
    private final LinkedList<EntityStateMachine> entities = new LinkedList();
    private int state = -1;
    private EntityStateMachine currentStateMachine;
    private int recursionMode = 0;
    private MimeEntity rootentity;

    public MimeTokenStream() {
        this(new MimeEntityConfig());
    }

    public MimeTokenStream(MimeEntityConfig config) {
        this(config, null, null);
    }

    public MimeTokenStream(MimeEntityConfig config, MutableBodyDescriptorFactory bodyDescFactory) {
        this(config, bodyDescFactory, null);
    }

    public MimeTokenStream(MimeEntityConfig config, MutableBodyDescriptorFactory bodyDescFactory, DecodeMonitor monitor) {
        this.config = config;
        this.monitor = monitor != null ? monitor : (config.isStrictParsing() ? DecodeMonitor.STRICT : DecodeMonitor.SILENT);
        this.bodyDescFactory = bodyDescFactory;
    }

    public void parse(InputStream stream) {
        this.doParse(stream, this.newBodyDescriptor(), 0);
    }

    public void parseHeadless(InputStream stream, String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Content type may not be null");
        }
        MutableBodyDescriptor newBodyDescriptor = this.newBodyDescriptor();
        try {
            newBodyDescriptor.addField(new RawField("Content-Type", contentType));
        }
        catch (MimeException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.doParse(stream, newBodyDescriptor, 5);
        try {
            this.next();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (MimeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected MutableBodyDescriptor newBodyDescriptor() {
        MutableBodyDescriptor result = this.bodyDescFactory != null ? this.bodyDescFactory.newInstance(this.monitor) : new DefaultBodyDescriptor(null, this.monitor);
        return result;
    }

    public void doParse(InputStream stream, MutableBodyDescriptor newBodyDescriptor, int start) {
        LineNumberInputStream lineSource = null;
        if (this.config.isCountLineNumbers()) {
            LineNumberInputStream lineInput;
            lineSource = lineInput = new LineNumberInputStream(stream);
            stream = lineInput;
        }
        this.rootentity = new MimeEntity(lineSource, stream, newBodyDescriptor, start, 1, this.config, this.monitor);
        this.rootentity.setRecursionMode(this.recursionMode);
        this.currentStateMachine = this.rootentity;
        this.entities.clear();
        this.entities.add(this.currentStateMachine);
        this.state = this.currentStateMachine.getState();
    }

    public boolean isRaw() {
        return this.recursionMode == 2;
    }

    public int getRecursionMode() {
        return this.recursionMode;
    }

    public void setRecursionMode(int mode) {
        this.recursionMode = mode;
        if (this.currentStateMachine != null) {
            this.currentStateMachine.setRecursionMode(mode);
        }
    }

    public void stop() {
        this.rootentity.stop();
    }

    public int getState() {
        return this.state;
    }

    public InputStream getInputStream() {
        return this.currentStateMachine.getContentStream();
    }

    public InputStream getDecodedInputStream() {
        return this.currentStateMachine.getDecodedContentStream();
    }

    public Reader getReader() {
        BodyDescriptor bodyDescriptor = this.getBodyDescriptor();
        String mimeCharset = bodyDescriptor.getCharset();
        Charset charset = mimeCharset == null || "".equals(mimeCharset) ? CharsetUtil.US_ASCII : Charset.forName(mimeCharset);
        InputStream instream = this.getDecodedInputStream();
        return new InputStreamReader(instream, charset);
    }

    public BodyDescriptor getBodyDescriptor() {
        return this.currentStateMachine.getBodyDescriptor();
    }

    public RawField getField() {
        return this.currentStateMachine.getField();
    }

    public int next() throws IOException, MimeException {
        if (this.state == -1 || this.currentStateMachine == null) {
            throw new IllegalStateException("No more tokens are available.");
        }
        while (this.currentStateMachine != null) {
            EntityStateMachine next = this.currentStateMachine.advance();
            if (next != null) {
                this.entities.add(next);
                this.currentStateMachine = next;
            }
            this.state = this.currentStateMachine.getState();
            if (this.state != -1) {
                return this.state;
            }
            this.entities.removeLast();
            if (this.entities.isEmpty()) {
                this.currentStateMachine = null;
                continue;
            }
            this.currentStateMachine = this.entities.getLast();
            this.currentStateMachine.setRecursionMode(this.recursionMode);
        }
        this.state = -1;
        return this.state;
    }

    public static final String stateToString(int state) {
        return AbstractEntity.stateToString(state);
    }

    public MimeEntityConfig getConfig() {
        return this.config;
    }
}

