/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.util.BitSet;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;
import org.apache.james.mime4j.util.MimeUtil;

public class RawField {
    private static final BitSet fieldChars;
    private ByteSequence raw;
    private int colonIdx;
    private int headerNameEndIdx;
    private String name;
    private String body;
    private final boolean obsoleteSyntax;

    public RawField(String name, String body) {
        this.name = name;
        this.body = body;
        this.raw = null;
        this.obsoleteSyntax = false;
    }

    public RawField(ByteSequence raw) throws MimeException {
        this.raw = raw;
        this.colonIdx = -1;
        boolean obsolete = false;
        block0: for (int i = 0; i < raw.length(); ++i) {
            if (fieldChars.get(raw.byteAt(i) & 0xFF)) continue;
            this.headerNameEndIdx = i;
            while (i < raw.length()) {
                int j = raw.byteAt(i) & 0xFF;
                if (j == 58) {
                    this.colonIdx = i;
                    break block0;
                }
                if (j != 32 && j != 9) {
                    throw new MimeException("Invalid header");
                }
                obsolete = true;
                ++i;
            }
            break;
        }
        if (this.colonIdx == -1) {
            throw new MimeException("Invalid header. No colon found.");
        }
        this.obsoleteSyntax = obsolete;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.parseName();
        }
        return this.name;
    }

    public String getBody() {
        if (this.body == null) {
            this.body = this.parseBody();
        }
        return this.body;
    }

    public ByteSequence getRaw() {
        if (this.raw == null) {
            this.raw = ContentUtil.encode(MimeUtil.fold(this.name + ": " + this.body, 0));
        }
        return this.raw;
    }

    public String toString() {
        return this.getName() + ": " + this.getBody();
    }

    private String parseName() {
        return ContentUtil.decode(this.raw, 0, this.headerNameEndIdx);
    }

    private String parseBody() {
        int offset = this.colonIdx + 1;
        if (this.raw.length() > offset + 1 && (this.raw.byteAt(offset) & 0xFF) == 32) {
            ++offset;
        }
        int length = this.raw.length() - offset;
        return MimeUtil.unfold(ContentUtil.decode(this.raw, offset, length));
    }

    public boolean isObsoleteSyntax() {
        return this.obsoleteSyntax;
    }

    static {
        int i;
        fieldChars = new BitSet();
        for (i = 33; i <= 57; ++i) {
            fieldChars.set(i);
        }
        for (i = 59; i <= 126; ++i) {
            fieldChars.set(i);
        }
    }
}

