/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.util.Vector;
import net.sf.antcontrib.property.AbstractPropertySetterTask;
import net.sf.antcontrib.property.RegexUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.Substitution;
import org.apache.tools.ant.util.regexp.Regexp;

public class RegexTask
extends AbstractPropertySetterTask {
    private String input;
    private RegularExpression regexp;
    private String select;
    private Substitution replace;
    private String defaultValue;
    private boolean caseSensitive = true;
    private boolean global = true;

    public void setInput(String input) {
        this.input = input;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setRegexp(String regex) {
        if (this.regexp != null) {
            throw new BuildException("Cannot specify more than one regular expression");
        }
        this.regexp = new RegularExpression();
        this.regexp.setPattern(regex);
    }

    public RegularExpression createRegexp() {
        if (this.regexp != null) {
            throw new BuildException("Cannot specify more than one regular expression");
        }
        this.regexp = new RegularExpression();
        return this.regexp;
    }

    public void setReplace(String replace) {
        if (this.replace != null) {
            throw new BuildException("Cannot specify more than one replace expression");
        }
        if (this.select != null) {
            throw new BuildException("You cannot specify both a select and replace expression");
        }
        this.replace = new Substitution();
        this.replace.setExpression(replace);
    }

    public Substitution createReplace() {
        if (this.replace != null) {
            throw new BuildException("Cannot specify more than one replace expression");
        }
        if (this.select != null) {
            throw new BuildException("You cannot specify both a select and replace expression");
        }
        this.replace = new Substitution();
        return this.replace;
    }

    public void setSelect(String select) {
        if (this.replace != null) {
            throw new BuildException("You cannot specify both a select and replace expression");
        }
        this.select = select;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    protected String doReplace() throws BuildException {
        if (this.replace == null) {
            throw new BuildException("No replace expression specified.");
        }
        int options = 0;
        if (!this.caseSensitive) {
            options |= 0x100;
        }
        if (this.global) {
            options |= 0x10;
        }
        Regexp sregex = this.regexp.getRegexp(this.project);
        String output = null;
        if (sregex.matches(this.input, options)) {
            output = sregex.substitute(this.input, this.replace.getExpression(this.getProject()), options);
        }
        if (output == null) {
            output = this.defaultValue;
        }
        return output;
    }

    protected String doSelect() throws BuildException {
        int options = 0;
        if (!this.caseSensitive) {
            options |= 0x100;
        }
        Regexp sregex = this.regexp.getRegexp(this.project);
        String output = this.select;
        Vector groups = sregex.getGroups(this.input, options);
        output = groups != null && groups.size() > 0 ? RegexUtil.select(this.select, groups) : null;
        if (output == null) {
            output = this.defaultValue;
        }
        return output;
    }

    protected void validate() {
        super.validate();
        if (this.regexp == null) {
            throw new BuildException("No match expression specified.");
        }
        if (this.replace == null && this.select == null) {
            throw new BuildException("You must specify either a replace or select expression");
        }
    }

    public void execute() throws BuildException {
        this.validate();
        String output = this.input;
        output = this.replace != null ? this.doReplace() : this.doSelect();
        if (output != null) {
            this.setPropertyValue(output);
        }
    }
}

