/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.antcontrib.property.AbstractPropertySetterTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;

public class SortList
extends AbstractPropertySetterTask {
    private String value;
    private Reference ref;
    private boolean casesensitive = true;
    private boolean numeric = false;
    private String delimiter = ",";
    private File orderPropertyFile;
    private String orderPropertyFilePrefix;

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
    }

    public void setCasesensitive(boolean casesenstive) {
        this.casesensitive = casesenstive;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOrderPropertyFile(File orderPropertyFile) {
        this.orderPropertyFile = orderPropertyFile;
    }

    public void setOrderPropertyFilePrefix(String orderPropertyFilePrefix) {
        this.orderPropertyFilePrefix = orderPropertyFilePrefix;
    }

    private static void mergeSort(String[] src, String[] dest, int low, int high, boolean caseSensitive, boolean numeric) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && SortList.compare(dest[j - 1], dest[j], caseSensitive, numeric) > 0; --j) {
                    SortList.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        SortList.mergeSort(dest, src, low, mid, caseSensitive, numeric);
        SortList.mergeSort(dest, src, mid, high, caseSensitive, numeric);
        if (SortList.compare(src[mid - 1], src[mid], caseSensitive, numeric) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && SortList.compare(src[p], src[q], caseSensitive, numeric) <= 0 ? src[p++] : src[q++];
        }
    }

    private static int compare(String s1, String s2, boolean casesensitive, boolean numeric) {
        int res = 0;
        if (numeric) {
            double d2;
            double d1 = new Double(s1);
            res = d1 < (d2 = new Double(s2).doubleValue()) ? -1 : (d1 == d2 ? 0 : 1);
        } else if (casesensitive) {
            res = s1.compareTo(s2);
        } else {
            Locale l = Locale.getDefault();
            res = s1.toLowerCase(l).compareTo(s2.toLowerCase(l));
        }
        return res;
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector sortByOrderPropertyFile(Vector props) throws IOException {
        Vector<String> vector;
        FileReader fr = null;
        Vector<String> orderedProps = new Vector<String>();
        try {
            fr = new FileReader(this.orderPropertyFile);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            String pname = "";
            int pos = 0;
            while ((line = br.readLine()) != null) {
                pos = line.indexOf(35);
                if (pos != -1) {
                    line = line.substring(0, pos).trim();
                }
                if (line.length() <= 0) continue;
                pos = line.indexOf(61);
                pname = pos != -1 ? line.substring(0, pos).trim() : line.trim();
                String prefPname = pname;
                if (this.orderPropertyFilePrefix != null) {
                    prefPname = this.orderPropertyFilePrefix + "." + prefPname;
                }
                if (!props.contains(prefPname) || orderedProps.contains(prefPname)) continue;
                orderedProps.addElement(prefPname);
            }
            Enumeration e = props.elements();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                if (orderedProps.contains(prop)) continue;
                orderedProps.addElement(prop);
            }
            vector = orderedProps;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            if (fr != null) {
                fr.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return vector;
    }

    protected void validate() {
        super.validate();
    }

    public void execute() {
        this.validate();
        String val = this.value;
        if (val == null && this.ref != null) {
            val = this.ref.getReferencedObject(this.project).toString();
        }
        if (val == null) {
            throw new BuildException("Either the 'Value' or 'Refid' attribute must be set.");
        }
        StringTokenizer st = new StringTokenizer(val, this.delimiter);
        Vector<String> vec = new Vector<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            vec.addElement(st.nextToken());
        }
        Object[] propList = null;
        if (this.orderPropertyFile != null) {
            try {
                Vector sorted = this.sortByOrderPropertyFile(vec);
                propList = new String[sorted.size()];
                sorted.copyInto(propList);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            String[] s = vec.toArray(new String[vec.size()]);
            propList = new String[s.length];
            System.arraycopy(s, 0, propList, 0, s.length);
            SortList.mergeSort(s, (String[])propList, 0, s.length, this.casesensitive, this.numeric);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < propList.length; ++i) {
            if (i != 0) {
                sb.append(this.delimiter);
            }
            sb.append((String)propList[i]);
        }
        this.setPropertyValue(sb.toString());
    }
}

