/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.james.mime4j.dom.field.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Header
implements Iterable<Field> {
    private List<Field> fields = new LinkedList<Field>();
    private Map<String, List<Field>> fieldMap = new HashMap<String, List<Field>>();

    public Header() {
    }

    public Header(Header other) {
        for (Field otherField : other.fields) {
            this.addField(otherField);
        }
    }

    public void addField(Field field) {
        List<Field> values = this.fieldMap.get(field.getName().toLowerCase());
        if (values == null) {
            values = new LinkedList<Field>();
            this.fieldMap.put(field.getName().toLowerCase(), values);
        }
        values.add(field);
        this.fields.add(field);
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Field getField(String name) {
        List<Field> l = this.fieldMap.get(name.toLowerCase());
        if (l != null && !l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    public List<Field> getFields(String name) {
        String lowerCaseName = name.toLowerCase();
        List<Field> l = this.fieldMap.get(lowerCaseName);
        List<Field> results = l == null || l.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(l);
        return results;
    }

    @Override
    public Iterator<Field> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    public int removeFields(String name) {
        String lowerCaseName = name.toLowerCase();
        List<Field> removed = this.fieldMap.remove(lowerCaseName);
        if (removed == null || removed.isEmpty()) {
            return 0;
        }
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field field = iterator.next();
            if (!field.getName().equalsIgnoreCase(name)) continue;
            iterator.remove();
        }
        return removed.size();
    }

    public void setField(Field field) {
        String lowerCaseName = field.getName().toLowerCase();
        List<Field> l = this.fieldMap.get(lowerCaseName);
        if (l == null || l.isEmpty()) {
            this.addField(field);
            return;
        }
        l.clear();
        l.add(field);
        int firstOccurrence = -1;
        int index = 0;
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field f = iterator.next();
            if (f.getName().equalsIgnoreCase(field.getName())) {
                iterator.remove();
                if (firstOccurrence == -1) {
                    firstOccurrence = index;
                }
            }
            ++index;
        }
        this.fields.add(firstOccurrence, field);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(128);
        for (Field field : this.fields) {
            str.append(field.toString());
            str.append("\r\n");
        }
        return str.toString();
    }
}

