/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Multipart
implements Body {
    protected List<Entity> bodyParts = new LinkedList<Entity>();
    private Entity parent = null;
    private String subType;

    public Multipart(String subType) {
        this.subType = subType;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    @Override
    public Entity getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Entity parent) {
        this.parent = parent;
        for (Entity bodyPart : this.bodyParts) {
            bodyPart.setParent(parent);
        }
    }

    public int getCount() {
        return this.bodyParts.size();
    }

    public List<Entity> getBodyParts() {
        return Collections.unmodifiableList(this.bodyParts);
    }

    public void setBodyParts(List<Entity> bodyParts) {
        this.bodyParts = bodyParts;
        for (Entity bodyPart : bodyParts) {
            bodyPart.setParent(this.parent);
        }
    }

    public void addBodyPart(Entity bodyPart) {
        if (bodyPart == null) {
            throw new IllegalArgumentException();
        }
        this.bodyParts.add(bodyPart);
        bodyPart.setParent(this.parent);
    }

    public void addBodyPart(Entity bodyPart, int index) {
        if (bodyPart == null) {
            throw new IllegalArgumentException();
        }
        this.bodyParts.add(index, bodyPart);
        bodyPart.setParent(this.parent);
    }

    public Entity removeBodyPart(int index) {
        Entity bodyPart = this.bodyParts.remove(index);
        bodyPart.setParent(null);
        return bodyPart;
    }

    public Entity replaceBodyPart(Entity bodyPart, int index) {
        if (bodyPart == null) {
            throw new IllegalArgumentException();
        }
        Entity replacedEntity = this.bodyParts.set(index, bodyPart);
        if (bodyPart == replacedEntity) {
            throw new IllegalArgumentException("Cannot replace body part with itself");
        }
        bodyPart.setParent(this.parent);
        replacedEntity.setParent(null);
        return replacedEntity;
    }

    public abstract String getPreamble();

    public abstract void setPreamble(String var1);

    public abstract String getEpilogue();

    public abstract void setEpilogue(String var1);

    @Override
    public void dispose() {
        for (Entity bodyPart : this.bodyParts) {
            bodyPart.dispose();
        }
    }
}

