/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceLoader {
    private ServiceLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T load(Class<T> spiClass) {
        Enumeration<URL> resources;
        String spiResURI = "META-INF/services/" + spiClass.getName();
        ClassLoader classLoader = spiClass.getClassLoader();
        try {
            resources = classLoader.getResources(spiResURI);
        }
        catch (IOException e) {
            return null;
        }
        block18: while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(resource.openStream()));
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) continue block18;
                    int cmtIdx = (line = line.trim()).indexOf(35);
                    if (cmtIdx != -1) {
                        line = line.substring(0, cmtIdx);
                        line = line.trim();
                    }
                    if (line.length() == 0) continue;
                    try {
                        Class<?> implClass = classLoader.loadClass(line);
                        if (!spiClass.isAssignableFrom(implClass)) continue;
                        Object impl = implClass.newInstance();
                        T t = spiClass.cast(impl);
                        return t;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

