/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.field.ParseException;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.util.ByteSequence;

public abstract class AbstractField
implements ParsedField {
    private final String name;
    private final String body;
    private final ByteSequence raw;
    protected DecodeMonitor monitor;

    protected AbstractField(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
        this.name = name;
        this.body = body;
        this.raw = raw;
        this.monitor = monitor != null ? monitor : DecodeMonitor.SILENT;
    }

    public String getName() {
        return this.name;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.raw.toByteArray());
    }

    public String getBody() {
        return this.body;
    }

    public boolean isValidField() {
        return this.getParseException() == null;
    }

    public ParseException getParseException() {
        return null;
    }

    public String toString() {
        return this.name + ": " + this.body;
    }
}

