/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.address.parser.AddressBuilder;
import org.apache.james.mime4j.field.address.parser.ParseException;
import org.apache.james.mime4j.util.ByteSequence;

public class AddressListFieldImpl
extends AbstractField
implements AddressListField {
    private boolean parsed = false;
    private AddressList addressList;
    private ParseException parseException;
    static final FieldParser<AddressListFieldImpl> PARSER = new FieldParser<AddressListFieldImpl>(){

        @Override
        public AddressListFieldImpl parse(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
            return new AddressListFieldImpl(name, body, raw, monitor);
        }
    };

    AddressListFieldImpl(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
        super(name, body, raw, monitor);
    }

    public AddressList getAddressList() {
        if (!this.parsed) {
            this.parse();
        }
        return this.addressList;
    }

    public ParseException getParseException() {
        if (!this.parsed) {
            this.parse();
        }
        return this.parseException;
    }

    private void parse() {
        String body = this.getBody();
        try {
            this.addressList = AddressBuilder.parseAddressList(body, this.monitor);
        }
        catch (ParseException e) {
            this.parseException = e;
        }
        this.parsed = true;
    }
}

