/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.io.StringReader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.contentdisposition.parser.ContentDispositionParser;
import org.apache.james.mime4j.field.contentdisposition.parser.ParseException;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.apache.james.mime4j.field.datetime.parser.TokenMgrError;
import org.apache.james.mime4j.util.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDispositionFieldImpl
extends AbstractField
implements ContentDispositionField {
    private boolean parsed = false;
    private String dispositionType = "";
    private Map<String, String> parameters = new HashMap<String, String>();
    private ParseException parseException;
    private boolean creationDateParsed;
    private Date creationDate;
    private boolean modificationDateParsed;
    private Date modificationDate;
    private boolean readDateParsed;
    private Date readDate;
    static final FieldParser<ContentDispositionFieldImpl> PARSER = new FieldParser<ContentDispositionFieldImpl>(){

        @Override
        public ContentDispositionFieldImpl parse(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
            return new ContentDispositionFieldImpl(name, body, raw, monitor);
        }
    };

    ContentDispositionFieldImpl(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
        super(name, body, raw, monitor);
    }

    @Override
    public ParseException getParseException() {
        if (!this.parsed) {
            this.parse();
        }
        return this.parseException;
    }

    @Override
    public String getDispositionType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType;
    }

    @Override
    public String getParameter(String name) {
        if (!this.parsed) {
            this.parse();
        }
        return this.parameters.get(name.toLowerCase());
    }

    @Override
    public Map<String, String> getParameters() {
        if (!this.parsed) {
            this.parse();
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public boolean isDispositionType(String dispositionType) {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType.equalsIgnoreCase(dispositionType);
    }

    @Override
    public boolean isInline() {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType.equals("inline");
    }

    @Override
    public boolean isAttachment() {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType.equals("attachment");
    }

    @Override
    public String getFilename() {
        return this.getParameter("filename");
    }

    @Override
    public Date getCreationDate() {
        if (!this.creationDateParsed) {
            this.creationDate = this.parseDate("creation-date");
            this.creationDateParsed = true;
        }
        return this.creationDate;
    }

    @Override
    public Date getModificationDate() {
        if (!this.modificationDateParsed) {
            this.modificationDate = this.parseDate("modification-date");
            this.modificationDateParsed = true;
        }
        return this.modificationDate;
    }

    @Override
    public Date getReadDate() {
        if (!this.readDateParsed) {
            this.readDate = this.parseDate("read-date");
            this.readDateParsed = true;
        }
        return this.readDate;
    }

    @Override
    public long getSize() {
        String value = this.getParameter("size");
        if (value == null) {
            return -1L;
        }
        try {
            long size = Long.parseLong(value);
            return size < 0L ? -1L : size;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private Date parseDate(String paramName) {
        String value = this.getParameter(paramName);
        if (value == null) {
            this.monitor.warn("Parsing " + paramName + " null", "returning null");
            return null;
        }
        try {
            return new DateTimeParser(new StringReader(value)).parseAll().getDate();
        }
        catch (org.apache.james.mime4j.field.datetime.parser.ParseException e) {
            this.monitor.warn("Parsing " + paramName + " '" + value + "': " + e.getMessage(), "returning null");
            return null;
        }
        catch (TokenMgrError e) {
            this.monitor.warn("Parsing " + paramName + " '" + value + "': " + e.getMessage(), "returning null");
            return null;
        }
    }

    private void parse() {
        String body = this.getBody();
        ContentDispositionParser parser = new ContentDispositionParser(new StringReader(body));
        try {
            parser.parseAll();
        }
        catch (ParseException e) {
            this.parseException = e;
        }
        catch (org.apache.james.mime4j.field.contentdisposition.parser.TokenMgrError e) {
            this.parseException = new ParseException(e.getMessage());
        }
        String dispositionType = parser.getDispositionType();
        if (dispositionType != null) {
            this.dispositionType = dispositionType.toLowerCase(Locale.US);
            List<String> paramNames = parser.getParamNames();
            List<String> paramValues = parser.getParamValues();
            if (paramNames != null && paramValues != null) {
                int len = Math.min(paramNames.size(), paramValues.size());
                for (int i = 0; i < len; ++i) {
                    String paramName = paramNames.get(i).toLowerCase(Locale.US);
                    String paramValue = paramValues.get(i);
                    this.parameters.put(paramName, paramValue);
                }
            }
        }
        this.parsed = true;
    }
}

