/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.AddressListFieldImpl;
import org.apache.james.mime4j.field.ContentDispositionFieldImpl;
import org.apache.james.mime4j.field.ContentTransferEncodingFieldImpl;
import org.apache.james.mime4j.field.ContentTypeFieldImpl;
import org.apache.james.mime4j.field.DateTimeFieldImpl;
import org.apache.james.mime4j.field.DelegatingFieldParser;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.MailboxFieldImpl;
import org.apache.james.mime4j.field.MailboxListFieldImpl;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;

public class DefaultFieldParser
extends DelegatingFieldParser {
    private static final DefaultFieldParser PARSER = new DefaultFieldParser();

    public static DefaultFieldParser getParser() {
        return PARSER;
    }

    public static ParsedField parse(ByteSequence raw, DecodeMonitor monitor) throws MimeException {
        RawField rawField = new RawField(raw);
        return PARSER.parse(rawField.getName(), rawField.getBody(), raw, monitor);
    }

    public static ParsedField parse(String rawStr, DecodeMonitor monitor) throws MimeException {
        ByteSequence raw = ContentUtil.encode((String)rawStr);
        return DefaultFieldParser.parse(raw, monitor);
    }

    public static ParsedField parse(String rawStr) throws MimeException {
        ByteSequence raw = ContentUtil.encode((String)rawStr);
        return DefaultFieldParser.parse(raw, DecodeMonitor.SILENT);
    }

    public DefaultFieldParser() {
        this.setFieldParser("Content-Transfer-Encoding", ContentTransferEncodingFieldImpl.PARSER);
        this.setFieldParser("Content-Type", ContentTypeFieldImpl.PARSER);
        this.setFieldParser("Content-Disposition", ContentDispositionFieldImpl.PARSER);
        FieldParser<DateTimeFieldImpl> dateTimeParser = DateTimeFieldImpl.PARSER;
        this.setFieldParser("Date", dateTimeParser);
        this.setFieldParser("Resent-Date", dateTimeParser);
        FieldParser<MailboxListFieldImpl> mailboxListParser = MailboxListFieldImpl.PARSER;
        this.setFieldParser("From", mailboxListParser);
        this.setFieldParser("Resent-From", mailboxListParser);
        FieldParser<MailboxFieldImpl> mailboxParser = MailboxFieldImpl.PARSER;
        this.setFieldParser("Sender", mailboxParser);
        this.setFieldParser("Resent-Sender", mailboxParser);
        FieldParser<AddressListFieldImpl> addressListParser = AddressListFieldImpl.PARSER;
        this.setFieldParser("To", addressListParser);
        this.setFieldParser("Resent-To", addressListParser);
        this.setFieldParser("Cc", addressListParser);
        this.setFieldParser("Resent-Cc", addressListParser);
        this.setFieldParser("Bcc", addressListParser);
        this.setFieldParser("Resent-Bcc", addressListParser);
        this.setFieldParser("Reply-To", addressListParser);
    }
}

