/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.util.HashMap;
import java.util.Map;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.UnstructuredFieldImpl;
import org.apache.james.mime4j.util.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingFieldParser
implements FieldParser<ParsedField> {
    private static final FieldParser<UnstructuredFieldImpl> DEFAULT_PARSER = UnstructuredFieldImpl.PARSER;
    private Map<String, FieldParser<? extends ParsedField>> parsers = new HashMap<String, FieldParser<? extends ParsedField>>();

    public void setFieldParser(String name, FieldParser<? extends ParsedField> parser) {
        this.parsers.put(name.toLowerCase(), parser);
    }

    public FieldParser<? extends ParsedField> getParser(String name) {
        FieldParser<? extends ParsedField> field = this.parsers.get(name.toLowerCase());
        if (field == null) {
            return DEFAULT_PARSER;
        }
        return field;
    }

    @Override
    public ParsedField parse(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
        FieldParser<? extends ParsedField> parser = this.getParser(name);
        return parser.parse(name, body, raw, monitor);
    }
}

