/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.MailboxField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.address.parser.AddressBuilder;
import org.apache.james.mime4j.field.address.parser.ParseException;
import org.apache.james.mime4j.util.ByteSequence;

public class MailboxFieldImpl
extends AbstractField
implements MailboxField {
    private boolean parsed = false;
    private Mailbox mailbox;
    private ParseException parseException;
    static final FieldParser<MailboxFieldImpl> PARSER = new FieldParser<MailboxFieldImpl>(){

        @Override
        public MailboxFieldImpl parse(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
            return new MailboxFieldImpl(name, body, raw, monitor);
        }
    };

    MailboxFieldImpl(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
        super(name, body, raw, monitor);
    }

    public Mailbox getMailbox() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mailbox;
    }

    public ParseException getParseException() {
        if (!this.parsed) {
            this.parse();
        }
        return this.parseException;
    }

    private void parse() {
        String body = this.getBody();
        try {
            MailboxList mailboxList = AddressBuilder.parseAddressList(body, this.monitor).flatten();
            if (mailboxList.size() > 0) {
                this.mailbox = mailboxList.get(0);
            }
        }
        catch (ParseException e) {
            this.parseException = e;
        }
        this.parsed = true;
    }
}

