/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.address.parser.AddressBuilder;
import org.apache.james.mime4j.field.address.parser.ParseException;
import org.apache.james.mime4j.util.ByteSequence;

public class MailboxListFieldImpl
extends AbstractField
implements MailboxListField {
    private boolean parsed = false;
    private MailboxList mailboxList;
    private ParseException parseException;
    static final FieldParser<MailboxListFieldImpl> PARSER = new FieldParser<MailboxListFieldImpl>(){

        @Override
        public MailboxListFieldImpl parse(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
            return new MailboxListFieldImpl(name, body, raw, monitor);
        }
    };

    MailboxListFieldImpl(String name, String body, ByteSequence raw, DecodeMonitor monitor) {
        super(name, body, raw, monitor);
    }

    public MailboxList getMailboxList() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mailboxList;
    }

    public ParseException getParseException() {
        if (!this.parsed) {
            this.parse();
        }
        return this.parseException;
    }

    private void parse() {
        String body = this.getBody();
        try {
            this.mailboxList = AddressBuilder.parseAddressList(body, this.monitor).flatten();
        }
        catch (ParseException e) {
            this.parseException = e;
        }
        this.parsed = true;
    }
}

