/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.address.formatter;

import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;

public class AddressFormatter {
    public static void format(StringBuilder sb, Address address, boolean includeRoute) {
        if (address == null) {
            return;
        }
        if (address instanceof Mailbox) {
            AddressFormatter.format(sb, (Mailbox)address, includeRoute);
        } else if (address instanceof Group) {
            AddressFormatter.format(sb, (Group)address, includeRoute);
        } else {
            throw new IllegalArgumentException("Unsuppported Address class: " + address.getClass());
        }
    }

    public static void encode(StringBuilder sb, Address address) {
        if (address == null) {
            return;
        }
        if (address instanceof Mailbox) {
            AddressFormatter.encode(sb, (Mailbox)address);
        } else if (address instanceof Group) {
            AddressFormatter.encode(sb, (Group)address);
        } else {
            throw new IllegalArgumentException("Unsuppported Address class: " + address.getClass());
        }
    }

    public static void format(StringBuilder sb, Mailbox mailbox, boolean includeRoute) {
        boolean includeAngleBrackets;
        if (sb == null) {
            throw new IllegalArgumentException("StringBuilder may not be null");
        }
        if (mailbox == null) {
            throw new IllegalArgumentException("Mailbox may not be null");
        }
        boolean bl = includeAngleBrackets = mailbox.getName() != null || (includeRoute &= mailbox.getRoute() != null);
        if (mailbox.getName() != null) {
            sb.append(mailbox.getName());
            sb.append(' ');
        }
        if (includeAngleBrackets) {
            sb.append('<');
        }
        if (includeRoute) {
            sb.append(mailbox.getRoute().toRouteString());
            sb.append(':');
        }
        sb.append(mailbox.getLocalPart());
        if (mailbox.getDomain() != null) {
            sb.append('@');
            sb.append(mailbox.getDomain());
        }
        if (includeAngleBrackets) {
            sb.append('>');
        }
    }

    public static String format(Mailbox mailbox, boolean includeRoute) {
        StringBuilder sb = new StringBuilder();
        AddressFormatter.format(sb, mailbox, includeRoute);
        return sb.toString();
    }

    public static void encode(StringBuilder sb, Mailbox mailbox) {
        if (sb == null) {
            throw new IllegalArgumentException("StringBuilder may not be null");
        }
        if (mailbox == null) {
            throw new IllegalArgumentException("Mailbox may not be null");
        }
        if (mailbox.getName() != null) {
            sb.append(EncoderUtil.encodeAddressDisplayName((String)mailbox.getName()));
            sb.append(" <");
        }
        sb.append(EncoderUtil.encodeAddressLocalPart((String)mailbox.getLocalPart()));
        if (mailbox.getDomain() != null) {
            sb.append('@');
            sb.append(mailbox.getDomain());
        }
        if (mailbox.getName() != null) {
            sb.append('>');
        }
    }

    public static String encode(Mailbox mailbox) {
        StringBuilder sb = new StringBuilder();
        AddressFormatter.encode(sb, mailbox);
        return sb.toString();
    }

    public static void format(StringBuilder sb, Group group, boolean includeRoute) {
        if (sb == null) {
            throw new IllegalArgumentException("StringBuilder may not be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("Group may not be null");
        }
        sb.append(group.getName());
        sb.append(':');
        boolean first = true;
        for (Mailbox mailbox : group.getMailboxes()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(' ');
            AddressFormatter.format(sb, mailbox, includeRoute);
        }
        sb.append(";");
    }

    public static String format(Group group, boolean includeRoute) {
        StringBuilder sb = new StringBuilder();
        AddressFormatter.format(sb, group, includeRoute);
        return sb.toString();
    }

    public static void encode(StringBuilder sb, Group group) {
        if (sb == null) {
            throw new IllegalArgumentException("StringBuilder may not be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("Group may not be null");
        }
        sb.append(EncoderUtil.encodeAddressDisplayName((String)group.getName()));
        sb.append(':');
        boolean first = true;
        for (Mailbox mailbox : group.getMailboxes()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(' ');
            AddressFormatter.encode(sb, mailbox);
        }
        sb.append(';');
    }

    public static String encode(Group group) {
        StringBuilder sb = new StringBuilder();
        AddressFormatter.encode(sb, group);
        return sb.toString();
    }
}

