/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.address.parser;

import java.io.StringReader;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.field.address.parser.AddressListParser;
import org.apache.james.mime4j.field.address.parser.Builder;
import org.apache.james.mime4j.field.address.parser.ParseException;

public class AddressBuilder {
    public static Address parseAddress(String rawAddressString, DecodeMonitor monitor) throws ParseException {
        AddressListParser parser = new AddressListParser(new StringReader(rawAddressString));
        return Builder.getInstance().buildAddress(parser.parseAddress(), monitor);
    }

    public static Address parseAddress(String rawAddressString) throws ParseException {
        return AddressBuilder.parseAddress(rawAddressString, DecodeMonitor.STRICT);
    }

    public static AddressList parseAddressList(String rawAddressList, DecodeMonitor monitor) throws ParseException {
        AddressListParser parser = new AddressListParser(new StringReader(rawAddressList));
        try {
            return Builder.getInstance().buildAddressList(parser.parseAddressList(), monitor);
        }
        catch (RuntimeException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public static AddressList parseAddressList(String rawAddressList) throws ParseException {
        return AddressBuilder.parseAddressList(rawAddressList, DecodeMonitor.STRICT);
    }

    public static Mailbox parseMailbox(String rawMailboxString, DecodeMonitor monitor) throws ParseException {
        AddressListParser parser = new AddressListParser(new StringReader(rawMailboxString));
        return Builder.getInstance().buildMailbox(parser.parseMailbox(), monitor);
    }

    public static Mailbox parseMailbox(String rawMailboxString) throws ParseException {
        return AddressBuilder.parseMailbox(rawMailboxString, DecodeMonitor.STRICT);
    }

    public static Group parseGroup(String rawGroupString, DecodeMonitor monitor) throws ParseException {
        Address address = AddressBuilder.parseAddress(rawGroupString, monitor);
        if (!(address instanceof Group)) {
            throw new ParseException("Not a group address");
        }
        return (Group)address;
    }

    public static Group parseGroup(String rawGroupString) throws ParseException {
        return AddressBuilder.parseGroup(rawGroupString, DecodeMonitor.STRICT);
    }
}

