/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.field.Field;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.DefaultFieldParser;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.RawField;

public class HeaderImpl
extends Header {
    public HeaderImpl() {
    }

    public HeaderImpl(Header other) {
        for (Field otherField : other.getFields()) {
            this.addField(otherField);
        }
    }

    public HeaderImpl(InputStream is, final DecodeMonitor monitor) throws IOException, MimeIOException {
        final MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void endHeader() {
                parser.stop();
            }

            public void field(RawField field) throws MimeException {
                ParsedField parsedField = DefaultFieldParser.parse(field.getRaw(), monitor);
                HeaderImpl.this.addField(parsedField);
            }
        });
        try {
            parser.parse(is);
        }
        catch (MimeException ex) {
            throw new MimeIOException(ex);
        }
    }
}

