/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.datetime.DateTime;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.apache.james.mime4j.field.datetime.parser.ParseException;
import org.apache.james.mime4j.field.language.parser.ContentLanguageParser;
import org.apache.james.mime4j.field.mimeversion.parser.MimeVersionParser;
import org.apache.james.mime4j.field.structured.parser.StructuredFieldParser;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.DefaultBodyDescriptor;
import org.apache.james.mime4j.stream.MutableBodyDescriptor;
import org.apache.james.mime4j.stream.RawField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaximalBodyDescriptor
extends DefaultBodyDescriptor {
    private static final int DEFAULT_MINOR_VERSION = 0;
    private static final int DEFAULT_MAJOR_VERSION = 1;
    private boolean isMimeVersionSet = false;
    private int mimeMinorVersion = 0;
    private int mimeMajorVersion = 1;
    private MimeException mimeVersionException;
    private String contentId = null;
    private boolean isContentIdSet = false;
    private String contentDescription = null;
    private boolean isContentDescriptionSet = false;
    private String contentDispositionType = null;
    private Map<String, String> contentDispositionParameters = Collections.emptyMap();
    private DateTime contentDispositionModificationDate = null;
    private MimeException contentDispositionModificationDateParseException = null;
    private DateTime contentDispositionCreationDate = null;
    private MimeException contentDispositionCreationDateParseException = null;
    private DateTime contentDispositionReadDate = null;
    private MimeException contentDispositionReadDateParseException = null;
    private long contentDispositionSize = -1L;
    private MimeException contentDispositionSizeParseException = null;
    private boolean isContentDispositionSet = false;
    private List<String> contentLanguage = null;
    private MimeException contentLanguageParseException = null;
    private boolean isContentLanguageSet;
    private MimeException contentLocationParseException = null;
    private String contentLocation = null;
    private boolean isContentLocationSet = false;
    private String contentMD5Raw = null;
    private boolean isContentMD5Set = false;

    protected MaximalBodyDescriptor() {
        this(null, null);
    }

    public MaximalBodyDescriptor(BodyDescriptor parent, DecodeMonitor monitor) {
        super(parent, monitor);
    }

    public MutableBodyDescriptor newChild() {
        return new MaximalBodyDescriptor((BodyDescriptor)this, this.getDecodeMonitor());
    }

    public void addField(RawField field) throws MimeException {
        String name = field.getName();
        String value = field.getBody();
        if ("mime-version".equals(name = name.trim().toLowerCase()) && !this.isMimeVersionSet) {
            this.parseMimeVersion(value);
        } else if ("content-id".equals(name) && !this.isContentIdSet) {
            this.parseContentId(value);
        } else if ("content-description".equals(name) && !this.isContentDescriptionSet) {
            this.parseContentDescription(value);
        } else if ("content-disposition".equals(name) && !this.isContentDispositionSet) {
            this.parseContentDisposition(value);
        } else if ("content-language".equals(name) && !this.isContentLanguageSet) {
            this.parseLanguage(value);
        } else if ("content-location".equals(name) && !this.isContentLocationSet) {
            this.parseLocation(value);
        } else if ("content-md5".equals(name) && !this.isContentMD5Set) {
            this.parseMD5(value);
        } else {
            super.addField(field);
        }
    }

    private void parseMD5(String value) {
        this.isContentMD5Set = true;
        if (value != null) {
            this.contentMD5Raw = value.trim();
        }
    }

    private void parseLocation(String value) {
        this.isContentLocationSet = true;
        if (value != null) {
            StringReader stringReader = new StringReader(value);
            StructuredFieldParser parser = new StructuredFieldParser(stringReader);
            try {
                this.contentLocation = parser.parse().replaceAll("\\s", "");
            }
            catch (MimeException e) {
                this.contentLocationParseException = e;
            }
        }
    }

    private void parseLanguage(String value) {
        this.isContentLanguageSet = true;
        if (value != null) {
            try {
                ContentLanguageParser parser = new ContentLanguageParser(new StringReader(value));
                this.contentLanguage = parser.parse();
            }
            catch (MimeException e) {
                this.contentLanguageParseException = e;
            }
        }
    }

    private void parseContentDisposition(String value) throws MimeException {
        String size;
        String contentDispositionReadDate;
        String contentDispositionCreationDate;
        this.isContentDispositionSet = true;
        this.contentDispositionParameters = DefaultBodyDescriptor.getHeaderParams((String)value, (DecodeMonitor)this.getDecodeMonitor());
        this.contentDispositionType = this.contentDispositionParameters.get("");
        String contentDispositionModificationDate = this.contentDispositionParameters.get("modification-date");
        if (contentDispositionModificationDate != null) {
            try {
                this.contentDispositionModificationDate = this.parseDate(contentDispositionModificationDate);
            }
            catch (ParseException e) {
                this.contentDispositionModificationDateParseException = e;
            }
        }
        if ((contentDispositionCreationDate = this.contentDispositionParameters.get("creation-date")) != null) {
            try {
                this.contentDispositionCreationDate = this.parseDate(contentDispositionCreationDate);
            }
            catch (ParseException e) {
                this.contentDispositionCreationDateParseException = e;
            }
        }
        if ((contentDispositionReadDate = this.contentDispositionParameters.get("read-date")) != null) {
            try {
                this.contentDispositionReadDate = this.parseDate(contentDispositionReadDate);
            }
            catch (ParseException e) {
                this.contentDispositionReadDateParseException = e;
            }
        }
        if ((size = this.contentDispositionParameters.get("size")) != null) {
            try {
                this.contentDispositionSize = Long.parseLong(size);
            }
            catch (NumberFormatException e) {
                this.contentDispositionSizeParseException = (MimeException)new MimeException(e.getMessage(), (Throwable)e).fillInStackTrace();
            }
        }
        this.contentDispositionParameters.remove("");
    }

    private DateTime parseDate(String date) throws ParseException {
        StringReader stringReader = new StringReader(date);
        DateTimeParser parser = new DateTimeParser(stringReader);
        DateTime result = parser.date_time();
        return result;
    }

    private void parseContentDescription(String value) {
        this.contentDescription = value == null ? "" : value.trim();
        this.isContentDescriptionSet = true;
    }

    private void parseContentId(String value) {
        this.contentId = value == null ? "" : value.trim();
        this.isContentIdSet = true;
    }

    private void parseMimeVersion(String value) {
        StringReader reader = new StringReader(value);
        MimeVersionParser parser = new MimeVersionParser(reader);
        try {
            int minor;
            parser.parse();
            int major = parser.getMajorVersion();
            if (major != -1) {
                this.mimeMajorVersion = major;
            }
            if ((minor = parser.getMinorVersion()) != -1) {
                this.mimeMinorVersion = minor;
            }
        }
        catch (MimeException e) {
            this.mimeVersionException = e;
        }
        this.isMimeVersionSet = true;
    }

    public int getMimeMajorVersion() {
        return this.mimeMajorVersion;
    }

    public int getMimeMinorVersion() {
        return this.mimeMinorVersion;
    }

    public MimeException getMimeVersionParseException() {
        return this.mimeVersionException;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getContentDispositionType() {
        return this.contentDispositionType;
    }

    public Map<String, String> getContentDispositionParameters() {
        return this.contentDispositionParameters;
    }

    public String getContentDispositionFilename() {
        return this.contentDispositionParameters.get("filename");
    }

    public DateTime getContentDispositionModificationDate() {
        return this.contentDispositionModificationDate;
    }

    public MimeException getContentDispositionModificationDateParseException() {
        return this.contentDispositionModificationDateParseException;
    }

    public DateTime getContentDispositionCreationDate() {
        return this.contentDispositionCreationDate;
    }

    public MimeException getContentDispositionCreationDateParseException() {
        return this.contentDispositionCreationDateParseException;
    }

    public DateTime getContentDispositionReadDate() {
        return this.contentDispositionReadDate;
    }

    public MimeException getContentDispositionReadDateParseException() {
        return this.contentDispositionReadDateParseException;
    }

    public long getContentDispositionSize() {
        return this.contentDispositionSize;
    }

    public MimeException getContentDispositionSizeParseException() {
        return this.contentDispositionSizeParseException;
    }

    public List<String> getContentLanguage() {
        return this.contentLanguage;
    }

    public MimeException getContentLanguageParseException() {
        return this.contentLanguageParseException;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public MimeException getContentLocationParseException() {
        return this.contentLocationParseException;
    }

    public String getContentMD5Raw() {
        return this.contentMD5Raw;
    }
}

