/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.MessageBuilder;
import org.apache.james.mime4j.dom.MessageBuilderFactory;
import org.apache.james.mime4j.message.MessageBuilderImpl;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.stream.MimeEntityConfig;
import org.apache.james.mime4j.stream.MutableBodyDescriptorFactory;

public class MessageBuilderFactoryImpl
extends MessageBuilderFactory {
    private StorageProvider storageProvider = null;
    private MimeEntityConfig mimeEntityConfig = null;
    private MutableBodyDescriptorFactory mutableBodyDescriptorFactory = null;

    public MessageBuilder newMessageBuilder() throws MimeException {
        MessageBuilderImpl m = new MessageBuilderImpl();
        if (this.storageProvider != null) {
            m.setStorageProvider(this.storageProvider);
        }
        if (this.mimeEntityConfig != null) {
            m.setMimeEntityConfig(this.mimeEntityConfig);
        }
        if (this.mutableBodyDescriptorFactory != null) {
            m.setMutableBodyDescriptorFactory(this.mutableBodyDescriptorFactory);
        }
        return m;
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if ("StorageProvider".equals(name)) {
            if (value instanceof StorageProvider) {
                this.storageProvider = (StorageProvider)value;
                return;
            }
            throw new IllegalArgumentException("Unsupported attribute value type for " + name + ", expected a StorageProvider");
        }
        if ("MimeEntityConfig".equals(name)) {
            if (value instanceof MimeEntityConfig) {
                this.mimeEntityConfig = (MimeEntityConfig)value;
                return;
            }
            throw new IllegalArgumentException("Unsupported attribute value type for " + name + ", expected a MimeEntityConfig");
        }
        if ("MutableBodyDescriptorFactory".equals(name)) {
            if (value instanceof MutableBodyDescriptorFactory) {
                this.mutableBodyDescriptorFactory = (MutableBodyDescriptorFactory)value;
                return;
            }
            throw new IllegalArgumentException("Unsupported attribute value type for " + name + ", expected a MutableBodyDescriptorFactory");
        }
        throw new IllegalArgumentException("Unsupported attribute: " + name);
    }
}

