/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentTransferEncodingField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.MailboxField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.field.ContentTransferEncodingFieldImpl;
import org.apache.james.mime4j.field.ContentTypeFieldImpl;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.mime4j.message.BodyCopier;
import org.apache.james.mime4j.message.EntityBuilder;
import org.apache.james.mime4j.message.MessageWriter;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.stream.MimeEntityConfig;
import org.apache.james.mime4j.stream.MutableBodyDescriptorFactory;
import org.apache.james.mime4j.util.MimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
extends Message {
    public MessageImpl() {
    }

    public MessageImpl(Message other) {
        if (other.getHeader() != null) {
            this.setHeader(new Header(other.getHeader()));
        }
        if (other.getBody() != null) {
            Body bodyCopy = BodyCopier.copy(other.getBody());
            this.setBody(bodyCopy);
        }
    }

    public MessageImpl(InputStream is) throws IOException, MimeIOException {
        this(is, null, DefaultStorageProvider.getInstance());
    }

    public MessageImpl(InputStream is, MimeEntityConfig config) throws IOException, MimeIOException {
        this(is, config, DefaultStorageProvider.getInstance());
    }

    public MessageImpl(InputStream is, MimeEntityConfig config, StorageProvider storageProvider, MutableBodyDescriptorFactory bodyDescFactory, DecodeMonitor monitor) throws IOException, MimeIOException {
        this(is, config, storageProvider, bodyDescFactory, monitor, true, false);
    }

    public MessageImpl(InputStream is, MimeEntityConfig config, StorageProvider storageProvider, MutableBodyDescriptorFactory bodyDescFactory, DecodeMonitor monitor, boolean contentDecoding, boolean flatMode) throws IOException, MimeIOException {
        try {
            DecodeMonitor mon = monitor != null ? monitor : DecodeMonitor.SILENT;
            MimeStreamParser parser = new MimeStreamParser(config, bodyDescFactory, mon);
            parser.setContentHandler((ContentHandler)new EntityBuilder(this, storageProvider, mon));
            parser.setContentDecoding(contentDecoding);
            if (flatMode) {
                parser.setFlat(true);
            }
            parser.parse(is);
        }
        catch (MimeException e) {
            throw new MimeIOException(e);
        }
    }

    public MessageImpl(InputStream is, MimeEntityConfig config, StorageProvider storageProvider, MutableBodyDescriptorFactory bodyDescFactory) throws IOException, MimeIOException {
        this(is, config, storageProvider, bodyDescFactory, null);
    }

    public MessageImpl(InputStream is, MimeEntityConfig config, StorageProvider storageProvider) throws IOException, MimeIOException {
        this(is, config, storageProvider, null, null);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        MessageWriter.DEFAULT.writeEntity(this, out);
    }

    @Override
    protected String newUniqueBoundary() {
        return MimeUtil.createUniqueBoundary();
    }

    @Override
    protected UnstructuredField newMessageId(String hostname) {
        return Fields.messageId(hostname);
    }

    @Override
    protected DateTimeField newDate(Date date, TimeZone zone) {
        return Fields.date("Date", date, zone);
    }

    @Override
    protected MailboxField newMailbox(String fieldName, Mailbox mailbox) {
        return Fields.mailbox(fieldName, mailbox);
    }

    @Override
    protected MailboxListField newMailboxList(String fieldName, Collection<Mailbox> mailboxes) {
        return Fields.mailboxList(fieldName, mailboxes);
    }

    @Override
    protected AddressListField newAddressList(String fieldName, Collection<Address> addresses) {
        return Fields.addressList(fieldName, addresses);
    }

    @Override
    protected UnstructuredField newSubject(String subject) {
        return Fields.subject(subject);
    }

    @Override
    protected ContentDispositionField newContentDisposition(String dispositionType, String filename, long size, Date creationDate, Date modificationDate, Date readDate) {
        return Fields.contentDisposition(dispositionType, filename, size, creationDate, modificationDate, readDate);
    }

    @Override
    protected ContentDispositionField newContentDisposition(String dispositionType, Map<String, String> parameters) {
        return Fields.contentDisposition(dispositionType, parameters);
    }

    @Override
    protected ContentTypeField newContentType(String mimeType, Map<String, String> parameters) {
        return Fields.contentType(mimeType, parameters);
    }

    @Override
    protected ContentTransferEncodingField newContentTransferEncoding(String contentTransferEncoding) {
        return Fields.contentTransferEncoding(contentTransferEncoding);
    }

    @Override
    protected String calcTransferEncoding(ContentTransferEncodingField f) {
        return ContentTransferEncodingFieldImpl.getEncoding(f);
    }

    @Override
    protected String calcMimeType(ContentTypeField child, ContentTypeField parent) {
        return ContentTypeFieldImpl.getMimeType(child, parent);
    }

    @Override
    protected String calcCharset(ContentTypeField contentType) {
        return ContentTypeFieldImpl.getCharset(contentType);
    }
}

