/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.james.mime4j.codec.CodecUtil;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.Field;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;
import org.apache.james.mime4j.util.MimeUtil;

public class MessageWriter {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHES = new byte[]{45, 45};
    public static final MessageWriter DEFAULT = new MessageWriter();

    protected MessageWriter() {
    }

    public void writeBody(Body body, OutputStream out) throws IOException {
        if (body instanceof Message) {
            this.writeEntity((Message)body, out);
        } else if (body instanceof Multipart) {
            this.writeMultipart((Multipart)body, out);
        } else if (body instanceof SingleBody) {
            ((SingleBody)body).writeTo(out);
        } else {
            throw new IllegalArgumentException("Unsupported body class");
        }
    }

    public void writeEntity(Entity entity, OutputStream out) throws IOException {
        Header header = entity.getHeader();
        if (header == null) {
            throw new IllegalArgumentException("Missing header");
        }
        this.writeHeader(header, out);
        Body body = entity.getBody();
        if (body == null) {
            throw new IllegalArgumentException("Missing body");
        }
        boolean binaryBody = body instanceof BinaryBody;
        OutputStream encOut = this.encodeStream(out, entity.getContentTransferEncoding(), binaryBody);
        this.writeBody(body, encOut);
        if (encOut != out) {
            encOut.close();
        }
    }

    public void writeMultipart(Multipart multipart, OutputStream out) throws IOException {
        ByteSequence epilogue;
        ByteSequence preamble;
        ContentTypeField contentType = this.getContentType(multipart);
        ByteSequence boundary = this.getBoundary(contentType);
        if (multipart instanceof MultipartImpl) {
            preamble = ((MultipartImpl)multipart).getPreambleRaw();
            epilogue = ((MultipartImpl)multipart).getEpilogueRaw();
        } else {
            preamble = multipart.getPreamble() != null ? ContentUtil.encode((String)multipart.getPreamble()) : null;
            ByteSequence byteSequence = epilogue = multipart.getEpilogue() != null ? ContentUtil.encode((String)multipart.getEpilogue()) : null;
        }
        if (preamble != null) {
            this.writeBytes(preamble, out);
            out.write(CRLF);
        }
        for (Entity bodyPart : multipart.getBodyParts()) {
            out.write(DASHES);
            this.writeBytes(boundary, out);
            out.write(CRLF);
            this.writeEntity(bodyPart, out);
            out.write(CRLF);
        }
        out.write(DASHES);
        this.writeBytes(boundary, out);
        out.write(DASHES);
        if (epilogue != null) {
            out.write(CRLF);
            this.writeBytes(epilogue, out);
        }
    }

    public void writeHeader(Header header, OutputStream out) throws IOException {
        for (Field field : header) {
            field.writeTo(out);
            out.write(CRLF);
        }
        out.write(CRLF);
    }

    protected OutputStream encodeStream(OutputStream out, String encoding, boolean binaryBody) throws IOException {
        if (MimeUtil.isBase64Encoding((String)encoding)) {
            return CodecUtil.wrapBase64((OutputStream)out);
        }
        if (MimeUtil.isQuotedPrintableEncoded((String)encoding)) {
            return CodecUtil.wrapQuotedPrintable((OutputStream)out, (boolean)binaryBody);
        }
        return out;
    }

    private ContentTypeField getContentType(Multipart multipart) {
        Entity parent = multipart.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Missing parent entity in multipart");
        }
        Header header = parent.getHeader();
        if (header == null) {
            throw new IllegalArgumentException("Missing header in parent entity");
        }
        ContentTypeField contentType = (ContentTypeField)header.getField("Content-Type");
        if (contentType == null) {
            throw new IllegalArgumentException("Content-Type field not specified");
        }
        return contentType;
    }

    private ByteSequence getBoundary(ContentTypeField contentType) {
        String boundary = contentType.getBoundary();
        if (boundary == null) {
            throw new IllegalArgumentException("Multipart boundary not specified");
        }
        return ContentUtil.encode((String)boundary);
    }

    private void writeBytes(ByteSequence byteSequence, OutputStream out) throws IOException {
        if (byteSequence instanceof ByteArrayBuffer) {
            ByteArrayBuffer bab = (ByteArrayBuffer)byteSequence;
            out.write(bab.buffer(), 0, bab.length());
        } else {
            out.write(byteSequence.toByteArray());
        }
    }
}

