/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;

public class MultipartImpl
extends Multipart {
    private ByteSequence preamble;
    private transient String preambleStrCache;
    private transient boolean preambleComputed = false;
    private ByteSequence epilogue;
    private transient String epilogueStrCache;
    private transient boolean epilogueComputed = false;

    public MultipartImpl(String subType) {
        super(subType);
        this.preamble = null;
        this.preambleStrCache = null;
        this.preambleComputed = true;
        this.epilogue = null;
        this.epilogueStrCache = null;
        this.epilogueComputed = true;
    }

    public MultipartImpl(Multipart other) {
        super(other.getSubType());
        for (Entity otherBodyPart : other.getBodyParts()) {
            BodyPart bodyPartCopy = new BodyPart(otherBodyPart);
            this.addBodyPart(bodyPartCopy);
        }
        if (other instanceof MultipartImpl) {
            this.preamble = ((MultipartImpl)other).preamble;
            this.epilogue = ((MultipartImpl)other).epilogue;
            this.preambleStrCache = ((MultipartImpl)other).preambleStrCache;
            this.epilogueStrCache = ((MultipartImpl)other).epilogueStrCache;
            this.preambleComputed = ((MultipartImpl)other).preambleComputed;
            this.epilogueComputed = ((MultipartImpl)other).epilogueComputed;
        } else {
            this.setPreamble(other.getPreamble());
            this.setEpilogue(other.getEpilogue());
        }
    }

    public ByteSequence getPreambleRaw() {
        return this.preamble;
    }

    public void setPreambleRaw(ByteSequence preamble) {
        this.preamble = preamble;
        this.preambleStrCache = null;
        this.preambleComputed = false;
    }

    public String getPreamble() {
        if (!this.preambleComputed) {
            this.preambleStrCache = this.preamble != null ? ContentUtil.decode((ByteSequence)this.preamble) : null;
            this.preambleComputed = true;
        }
        return this.preambleStrCache;
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble != null ? ContentUtil.encode((String)preamble) : null;
        this.preambleStrCache = preamble;
        this.preambleComputed = true;
    }

    public ByteSequence getEpilogueRaw() {
        return this.epilogue;
    }

    public void setEpilogueRaw(ByteSequence epilogue) {
        this.epilogue = epilogue;
        this.epilogueStrCache = null;
        this.epilogueComputed = false;
    }

    public String getEpilogue() {
        if (!this.epilogueComputed) {
            this.epilogueStrCache = this.epilogue != null ? ContentUtil.decode((ByteSequence)this.epilogue) : null;
            this.epilogueComputed = true;
        }
        return this.epilogueStrCache;
    }

    public void setEpilogue(String epilogue) {
        this.epilogue = epilogue != null ? ContentUtil.encode((String)epilogue) : null;
        this.epilogueStrCache = epilogue;
        this.epilogueComputed = true;
    }
}

