package com.koushikdutta.superuser;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.Uri;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;

import com.koushikdutta.widgets.BetterListFragment;
import com.koushikdutta.widgets.ListItem;

public class AboutFragment extends BetterListFragment {
    ContextThemeWrapper mWrapper;
    @Override
    public Context getContext() {
        if (mWrapper != null)
            return mWrapper;
        TypedValue value = new TypedValue();
        super.getContext().getTheme().resolveAttribute(R.attr.largeIconTheme, value, true);
        mWrapper = new ContextThemeWrapper(super.getContext(), value.resourceId);
        return mWrapper;
    }
    
    @Override
    protected void onCreate(Bundle savedInstanceState, View view) {
        super.onCreate(savedInstanceState, view);

        PackageManager manager = getContext().getPackageManager();
        String version = "unknown";
        try {
            PackageInfo info = manager.getPackageInfo(getContext().getPackageName(), 0);
            version = info.versionName;
        }
        catch (NameNotFoundException e) {
        }
        
        final String uri = "https://f-droid.org/repository/browse/?fdid=org.fdroid.superuser";
        addItem(R.string.about, new ListItem(getInternal(), getString(R.string.superuser), version, R.drawable.ic_launcher) {
            @Override
            public void onClick(View view) {
                super.onClick(view);
                Intent i = new Intent();
                i.setAction(Intent.ACTION_VIEW);
                i.setData(Uri.parse(uri));
                startActivity(i);
            }
        });

    }
}
