/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.Generator;
import com.google.ical.iter.IntSet;
import com.google.ical.iter.Util;
import com.google.ical.util.DTBuilder;
import com.google.ical.util.Predicate;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.Frequency;
import com.google.ical.values.Weekday;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstanceGenerators {
    static Generator serialInstanceGenerator(final Predicate<? super DateValue> filter, final Generator yearGenerator, final Generator monthGenerator, final Generator dayGenerator) {
        return new Generator(){

            public boolean generate(DTBuilder builder) throws Generator.IteratorShortCircuitingException {
                block0: while (true) {
                    if (!dayGenerator.generate(builder)) {
                        do {
                            if (monthGenerator.generate(builder)) continue block0;
                        } while (yearGenerator.generate(builder));
                        return false;
                    }
                    if (filter.apply(builder.toDate())) break;
                }
                return true;
            }
        };
    }

    static Generator bySetPosInstanceGenerator(int[] setPos, final Frequency freq, final Weekday wkst, Predicate<? super DateValue> filter, final Generator yearGenerator, final Generator monthGenerator, Generator dayGenerator) {
        final int[] uSetPos = Util.uniquify(setPos);
        final Generator serialInstanceGenerator = InstanceGenerators.serialInstanceGenerator(filter, yearGenerator, monthGenerator, dayGenerator);
        final int maxPos = uSetPos[uSetPos.length - 1];
        final boolean allPositive = uSetPos[0] > 0;
        return new Generator(){
            DateValue pushback = null;
            boolean first = true;
            boolean done = false;
            List<DateValue> candidates;
            int i;

            public boolean generate(DTBuilder builder) throws Generator.IteratorShortCircuitingException {
                while (null == this.candidates || this.i >= this.candidates.size()) {
                    int[] absSetPos;
                    int limit;
                    if (this.done) {
                        return false;
                    }
                    DateValue d0 = null;
                    if (null != this.pushback) {
                        d0 = this.pushback;
                        builder.year = d0.year();
                        builder.month = d0.month();
                        builder.day = d0.day();
                        this.pushback = null;
                    } else if (!this.first) {
                        switch (freq) {
                            case YEARLY: {
                                if (!yearGenerator.generate(builder)) {
                                    return false;
                                }
                            }
                            case MONTHLY: {
                                while (!monthGenerator.generate(builder)) {
                                    if (yearGenerator.generate(builder)) continue;
                                    return false;
                                }
                                break;
                            }
                            case WEEKLY: {
                                DateValue nextWeek = Util.nextWeekStart(builder.toDate(), wkst);
                                do {
                                    if (serialInstanceGenerator.generate(builder)) continue;
                                    return false;
                                } while (builder.compareTo(nextWeek) < 0);
                                d0 = builder.toDate();
                                break;
                            }
                        }
                    } else {
                        this.first = false;
                    }
                    ArrayList<DateValue> dates = new ArrayList<DateValue>();
                    if (null != d0) {
                        dates.add(d0);
                    }
                    int n = limit = allPositive ? maxPos : Integer.MAX_VALUE;
                    while (limit > dates.size()) {
                        if (!serialInstanceGenerator.generate(builder)) {
                            this.done = true;
                        }
                        DateValue d = builder.toDate();
                        boolean contained = false;
                        if (null == d0) {
                            d0 = d;
                            contained = true;
                        } else {
                            switch (freq) {
                                case WEEKLY: {
                                    int nb = TimeUtils.daysBetween(d, d0);
                                    contained = nb < 7 && (7 + Weekday.valueOf((DateValue)d).javaDayNum - wkst.javaDayNum) % 7 > (7 + Weekday.valueOf((DateValue)d0).javaDayNum - wkst.javaDayNum) % 7;
                                    break;
                                }
                                case MONTHLY: {
                                    contained = d0.month() == d.month() && d0.year() == d.year();
                                    break;
                                }
                                case YEARLY: {
                                    contained = d0.year() == d.year();
                                    break;
                                }
                            }
                        }
                        if (contained) {
                            dates.add(d);
                            continue;
                        }
                        this.pushback = d;
                        break;
                    }
                    if (allPositive) {
                        absSetPos = uSetPos;
                    } else {
                        IntSet uAbsSetPos = new IntSet();
                        for (int j = 0; j < uSetPos.length; ++j) {
                            int p = uSetPos[j];
                            if (p < 0) {
                                p = dates.size() + p + 1;
                            }
                            uAbsSetPos.add(p);
                        }
                        absSetPos = uAbsSetPos.toIntArray();
                    }
                    this.candidates = new ArrayList<DateValue>();
                    for (int j = 0; j < absSetPos.length; ++j) {
                        int p = absSetPos[j] - 1;
                        if (p < 0 || p >= dates.size()) continue;
                        this.candidates.add((DateValue)dates.get(p));
                    }
                    this.i = 0;
                    if (!this.candidates.isEmpty()) continue;
                    this.candidates = null;
                }
                DateValue d = this.candidates.get(this.i++);
                builder.year = d.year();
                builder.month = d.month();
                builder.day = d.day();
                return true;
            }
        };
    }

    private InstanceGenerators() {
    }
}

