/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.DateValueComparison;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.values.DateValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RDateIteratorImpl
implements RecurrenceIterator {
    private int i;
    private DateValue[] datesUtc;

    RDateIteratorImpl(DateValue[] datesUtc) {
        this.datesUtc = (DateValue[])datesUtc.clone();
        assert (RDateIteratorImpl.increasing((Comparable[])datesUtc));
    }

    @Override
    public boolean hasNext() {
        return this.i < this.datesUtc.length;
    }

    @Override
    public DateValue next() {
        return this.datesUtc[this.i++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void advanceTo(DateValue newStartUtc) {
        long startCmp = DateValueComparison.comparable(newStartUtc);
        while (this.i < this.datesUtc.length && startCmp > DateValueComparison.comparable(this.datesUtc[this.i])) {
            ++this.i;
        }
    }

    private static <C extends Comparable<C>> boolean increasing(C[] els) {
        int i = els.length;
        while (--i >= 1) {
            if (els[i - 1].compareTo(els[i]) <= 0) continue;
            return false;
        }
        return true;
    }
}

