/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.Generator;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.ThrottledGenerator;
import com.google.ical.util.DTBuilder;
import com.google.ical.util.Predicate;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.TimeValue;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RRuleIteratorImpl
implements RecurrenceIterator {
    private final Predicate<? super DateValue> condition_;
    private final Predicate<? super DateValue> filter_;
    private final Generator instanceGenerator_;
    private final ThrottledGenerator yearGenerator_;
    private final Generator monthGenerator_;
    private final Generator dayGenerator_;
    private DateValue pendingUtc_;
    private DTBuilder builder_;
    private boolean done_;
    private final DateValue dtStart_;
    private final boolean canShortcutAdvance_;
    private final TimeZone tzid_;
    private static final DateValue MIN_DATE = new DateValueImpl(Integer.MIN_VALUE, 1, 1);
    private DateValue lastUtc_ = MIN_DATE;

    RRuleIteratorImpl(DateValue dtStart, TimeZone tzid, Predicate<? super DateValue> condition, Predicate<? super DateValue> filter, Generator instanceGenerator, ThrottledGenerator yearGenerator, Generator monthGenerator, Generator dayGenerator, boolean canShortcutAdvance, TimeValue startTime) {
        this.condition_ = condition;
        this.filter_ = filter;
        this.instanceGenerator_ = instanceGenerator;
        this.yearGenerator_ = yearGenerator;
        this.monthGenerator_ = monthGenerator;
        this.dayGenerator_ = dayGenerator;
        this.dtStart_ = dtStart;
        this.tzid_ = tzid;
        this.canShortcutAdvance_ = canShortcutAdvance;
        this.builder_ = new DTBuilder(dtStart);
        if (null != startTime) {
            this.builder_.hour = startTime.hour();
            this.builder_.minute = startTime.minute();
            this.builder_.second = startTime.second();
        }
        try {
            this.yearGenerator_.generate(this.builder_);
            this.monthGenerator_.generate(this.builder_);
        }
        catch (Generator.IteratorShortCircuitingException ex) {
            this.done_ = true;
        }
        while (!this.done_) {
            this.pendingUtc_ = this.generateInstance();
            if (null == this.pendingUtc_) {
                this.done_ = true;
                break;
            }
            if (this.pendingUtc_.compareTo(TimeUtils.toUtc(dtStart, tzid)) < 0) continue;
            if (this.condition_.apply(this.pendingUtc_)) break;
            this.done_ = true;
            this.pendingUtc_ = null;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        if (null == this.pendingUtc_) {
            this.fetchNext();
        }
        return null != this.pendingUtc_;
    }

    @Override
    public DateValue next() {
        if (null == this.pendingUtc_) {
            this.fetchNext();
        }
        DateValue next = this.pendingUtc_;
        this.pendingUtc_ = null;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void advanceTo(DateValue dateUtc) {
        if (this.pendingUtc_ != null && dateUtc.compareTo(this.pendingUtc_) <= 0) {
            return;
        }
        DateValue dateLocal = TimeUtils.fromUtc(dateUtc, this.tzid_);
        if (dateLocal.compareTo(this.builder_.toDate()) <= 0) {
            return;
        }
        this.pendingUtc_ = null;
        try {
            if (this.canShortcutAdvance_) {
                if (this.builder_.year < dateLocal.year()) {
                    do {
                        if (this.yearGenerator_.generate(this.builder_)) continue;
                        this.done_ = true;
                        return;
                    } while (this.builder_.year < dateLocal.year());
                    while (!this.monthGenerator_.generate(this.builder_)) {
                        if (this.yearGenerator_.generate(this.builder_)) continue;
                        this.done_ = true;
                        return;
                    }
                }
                while (this.builder_.year == dateLocal.year() && this.builder_.month < dateLocal.month()) {
                    while (!this.monthGenerator_.generate(this.builder_)) {
                        if (this.yearGenerator_.generate(this.builder_)) continue;
                        this.done_ = true;
                        return;
                    }
                }
            }
            while (!this.done_) {
                DateValue dUtc = this.generateInstance();
                if (null == dUtc) {
                    this.done_ = true;
                    continue;
                }
                if (!this.condition_.apply(dUtc)) {
                    this.done_ = true;
                    continue;
                }
                if (dUtc.compareTo(dateUtc) < 0) continue;
                this.pendingUtc_ = dUtc;
                break;
            }
        }
        catch (Generator.IteratorShortCircuitingException ex) {
            this.done_ = true;
        }
    }

    private void fetchNext() {
        if (null != this.pendingUtc_ || this.done_) {
            return;
        }
        DateValue dUtc = this.generateInstance();
        if (null != dUtc && this.condition_.apply(dUtc)) {
            this.pendingUtc_ = dUtc;
            this.yearGenerator_.workDone();
        } else {
            this.done_ = true;
        }
    }

    private DateValue generateInstance() {
        try {
            DateValue dUtc;
            do {
                if (this.instanceGenerator_.generate(this.builder_)) continue;
                return null;
            } while ((dUtc = this.dtStart_ instanceof TimeValue ? TimeUtils.toUtc(this.builder_.toDateTime(), this.tzid_) : this.builder_.toDate()).compareTo(this.lastUtc_) <= 0);
            return dUtc;
        }
        catch (Generator.IteratorShortCircuitingException ex) {
            return null;
        }
    }
}

