/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.Frequency;
import com.google.ical.values.IcalObject;
import com.google.ical.values.IcalParseUtil;
import com.google.ical.values.IcalSchema;
import com.google.ical.values.IcalValueType;
import com.google.ical.values.RDateList;
import com.google.ical.values.RRule;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RRuleSchema
extends IcalSchema {
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern SEMI = Pattern.compile(";");
    private static final Pattern X_NAME_RE = Pattern.compile("^X-", 2);
    private static final Pattern RRULE_PARTS = Pattern.compile("^(FREQ|UNTIL|COUNT|INTERVAL|BYSECOND|BYMINUTE|BYHOUR|BYDAY|BYMONTHDAY|BYYEARDAY|BYWEEKDAY|BYWEEKNO|BYMONTH|BYSETPOS|WKST|X-[A-Z0-9\\-]+)=(.*)", 2);
    private static final Pattern NUM_DAY = Pattern.compile("^([+\\-]?\\d\\d?)?(SU|MO|TU|WE|TH|FR|SA)$", 2);
    private static final Map<String, IcalSchema.ParamRule> PARAM_RULES;
    private static final Map<String, IcalSchema.ContentRule> CONTENT_RULES;
    private static final Map<String, IcalSchema.ObjectRule> OBJECT_RULES;
    private static final Map<String, IcalSchema.XformRule> XFORM_RULES;

    static RRuleSchema instance() {
        return new RRuleSchema();
    }

    private RRuleSchema() {
        super(PARAM_RULES, CONTENT_RULES, OBJECT_RULES, XFORM_RULES);
    }

    private static int[] parseIntList(String commaSeparatedString, int absmin, int absmax, IcalSchema schema) throws ParseException {
        String[] parts = COMMA.split(commaSeparatedString);
        int[] out = new int[parts.length];
        int i = parts.length;
        while (--i >= 0) {
            try {
                int n = Integer.parseInt(parts[i]);
                int absn = Math.abs(n);
                if (absmin > absn || absmax < absn) {
                    schema.badPart(commaSeparatedString, null);
                }
                out[i] = n;
            }
            catch (NumberFormatException ex) {
                schema.badPart(commaSeparatedString, ex.getMessage());
            }
        }
        return out;
    }

    private static int[] parseUnsignedIntList(String commaSeparatedString, int min, int max, IcalSchema schema) throws ParseException {
        String[] parts = COMMA.split(commaSeparatedString);
        int[] out = new int[parts.length];
        int i = parts.length;
        while (--i >= 0) {
            try {
                int n = Integer.parseInt(parts[i]);
                if (min > n || max < n) {
                    schema.badPart(commaSeparatedString, null);
                }
                out[i] = n;
            }
            catch (NumberFormatException ex) {
                schema.badPart(commaSeparatedString, ex.getMessage());
            }
        }
        return out;
    }

    static {
        HashMap<String, IcalSchema.ParamRule> paramRules = new HashMap<String, IcalSchema.ParamRule>();
        HashMap<String, IcalSchema.ContentRule> contentRules = new HashMap<String, IcalSchema.ContentRule>();
        HashMap<String, IcalSchema.ObjectRule> objectRules = new HashMap<String, IcalSchema.ObjectRule>();
        HashMap<String, IcalSchema.XformRule> xformRules = new HashMap<String, IcalSchema.XformRule>();
        objectRules.put("RRULE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema schema, Map<String, String> params, String content, IcalObject target) throws ParseException {
                schema.applyParamsSchema("rrulparam", params, target);
                schema.applyContentSchema("recur", content, target);
            }
        });
        objectRules.put("EXRULE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema schema, Map<String, String> params, String content, IcalObject target) throws ParseException {
                schema.applyParamsSchema("exrparam", params, target);
                schema.applyContentSchema("recur", content, target);
            }
        });
        IcalSchema.ParamRule xparamsOnly = new IcalSchema.ParamRule(){

            public void apply(IcalSchema schema, String name, String value, IcalObject out) throws ParseException {
                schema.badParam(name, value);
            }
        };
        paramRules.put("rrulparam", xparamsOnly);
        paramRules.put("exrparam", xparamsOnly);
        contentRules.put("recur", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String content, IcalObject target) throws ParseException {
                String[] parts = SEMI.split(content);
                HashMap<String, String> partMap = new HashMap<String, String>();
                for (int i = 0; i < parts.length; ++i) {
                    String p = parts[i];
                    Matcher m = RRULE_PARTS.matcher(p);
                    if (!m.matches()) {
                        schema.badPart(p, null);
                    }
                    String k = m.group(1).toUpperCase();
                    String v = m.group(2);
                    if (partMap.containsKey(k)) {
                        schema.dupePart(p);
                    }
                    partMap.put(k, v);
                }
                if (!partMap.containsKey("FREQ")) {
                    schema.missingPart("FREQ", content);
                }
                if (partMap.containsKey("UNTIL") && partMap.containsKey("COUNT")) {
                    schema.badPart(content, "UNTIL & COUNT are exclusive");
                }
                for (Map.Entry part : partMap.entrySet()) {
                    if (X_NAME_RE.matcher((CharSequence)part.getKey()).matches()) continue;
                    schema.applyContentSchema((String)part.getKey(), (String)part.getValue(), target);
                }
            }
        });
        objectRules.put("EXDATE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema schema, Map<String, String> params, String content, IcalObject target) throws ParseException {
                schema.applyParamsSchema("exdtparam", params, target);
                for (String part : COMMA.split(content)) {
                    schema.applyContentSchema("exdtval", part, target);
                }
            }
        });
        contentRules.put("FREQ", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setFreq((Frequency)((Object)schema.applyXformSchema("freq", value)));
            }
        });
        contentRules.put("UNTIL", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setUntil((DateValue)schema.applyXformSchema("enddate", value));
            }
        });
        contentRules.put("COUNT", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setCount(Integer.parseInt(value));
            }
        });
        contentRules.put("INTERVAL", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setInterval(Integer.parseInt(value));
            }
        });
        contentRules.put("BYSECOND", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setBySecond((int[])schema.applyXformSchema("byseclist", value));
            }
        });
        contentRules.put("BYMINUTE", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setByMinute((int[])schema.applyXformSchema("byminlist", value));
            }
        });
        contentRules.put("BYHOUR", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setByHour((int[])schema.applyXformSchema("byhrlist", value));
            }
        });
        contentRules.put("BYDAY", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setByDay((List)schema.applyXformSchema("bywdaylist", value));
            }
        });
        contentRules.put("BYMONTHDAY", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setByMonthDay((int[])schema.applyXformSchema("bymodaylist", value));
            }
        });
        contentRules.put("BYYEARDAY", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setByYearDay((int[])schema.applyXformSchema("byyrdaylist", value));
            }
        });
        contentRules.put("BYWEEKNO", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setByWeekNo((int[])schema.applyXformSchema("bywknolist", value));
            }
        });
        contentRules.put("BYMONTH", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setByMonth((int[])schema.applyXformSchema("bymolist", value));
            }
        });
        contentRules.put("BYSETPOS", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setBySetPos((int[])schema.applyXformSchema("bysplist", value));
            }
        });
        contentRules.put("WKST", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String value, IcalObject target) throws ParseException {
                ((RRule)target).setWkSt((Weekday)((Object)schema.applyXformSchema("weekday", value)));
            }
        });
        xformRules.put("freq", new IcalSchema.XformRule(){

            public Frequency apply(IcalSchema schema, String value) throws ParseException {
                return Frequency.valueOf(value);
            }
        });
        xformRules.put("enddate", new IcalSchema.XformRule(){

            public DateValue apply(IcalSchema schema, String value) throws ParseException {
                return IcalParseUtil.parseDateValue(value.toUpperCase());
            }
        });
        xformRules.put("byseclist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema schema, String value) throws ParseException {
                return RRuleSchema.parseUnsignedIntList(value, 0, 59, schema);
            }
        });
        xformRules.put("byminlist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema schema, String value) throws ParseException {
                return RRuleSchema.parseUnsignedIntList(value, 0, 59, schema);
            }
        });
        xformRules.put("byhrlist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema schema, String value) throws ParseException {
                return RRuleSchema.parseUnsignedIntList(value, 0, 23, schema);
            }
        });
        xformRules.put("bywdaylist", new IcalSchema.XformRule(){

            @Override
            public List<WeekdayNum> apply(IcalSchema schema, String value) throws ParseException {
                String[] parts = COMMA.split(value);
                ArrayList<WeekdayNum> weekdays = new ArrayList<WeekdayNum>(parts.length);
                for (String p : parts) {
                    int n;
                    Matcher m = NUM_DAY.matcher(p);
                    if (!m.matches()) {
                        schema.badPart(p, null);
                    }
                    Weekday wday = Weekday.valueOf(m.group(2).toUpperCase());
                    String numText = m.group(1);
                    if (null == numText || "".equals(numText)) {
                        n = 0;
                    } else {
                        int absn;
                        n = Integer.parseInt(numText);
                        int n2 = absn = n < 0 ? -n : n;
                        if (1 > absn || 53 < absn) {
                            schema.badPart(p, null);
                        }
                    }
                    weekdays.add(new WeekdayNum(n, wday));
                }
                return weekdays;
            }
        });
        xformRules.put("weekday", new IcalSchema.XformRule(){

            public Weekday apply(IcalSchema schema, String value) throws ParseException {
                return Weekday.valueOf(value.toUpperCase());
            }
        });
        xformRules.put("bymodaylist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema schema, String value) throws ParseException {
                return RRuleSchema.parseIntList(value, 1, 31, schema);
            }
        });
        xformRules.put("byyrdaylist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema schema, String value) throws ParseException {
                return RRuleSchema.parseIntList(value, 1, 366, schema);
            }
        });
        xformRules.put("bywknolist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema schema, String value) throws ParseException {
                return RRuleSchema.parseIntList(value, 1, 53, schema);
            }
        });
        xformRules.put("bymolist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema schema, String value) throws ParseException {
                return RRuleSchema.parseIntList(value, 1, 12, schema);
            }
        });
        xformRules.put("bysplist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema schema, String value) throws ParseException {
                return RRuleSchema.parseIntList(value, 1, 366, schema);
            }
        });
        objectRules.put("RDATE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema schema, Map<String, String> params, String content, IcalObject target) throws ParseException {
                schema.applyParamsSchema("rdtparam", params, target);
                schema.applyContentSchema("rdtval", content, target);
            }
        });
        objectRules.put("EXDATE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema schema, Map<String, String> params, String content, IcalObject target) throws ParseException {
                schema.applyParamsSchema("rdtparam", params, target);
                schema.applyContentSchema("rdtval", content, target);
            }
        });
        paramRules.put("rdtparam", new IcalSchema.ParamRule(){

            public void apply(IcalSchema schema, String name, String value, IcalObject out) throws ParseException {
                if ("value".equalsIgnoreCase(name)) {
                    if ("date-time".equalsIgnoreCase(value) || "date".equalsIgnoreCase(value) || "period".equalsIgnoreCase(value)) {
                        ((RDateList)out).setValueType(IcalValueType.fromIcal(value));
                    } else {
                        schema.badParam(name, value);
                    }
                } else if ("tzid".equalsIgnoreCase(name)) {
                    TimeZone tz;
                    if (value.startsWith("/")) {
                        value = value.substring(1).trim();
                    }
                    if (null == (tz = TimeUtils.timeZoneForName(value.replaceAll(" ", "_")))) {
                        schema.badParam(name, value);
                    }
                    ((RDateList)out).setTzid(tz);
                } else {
                    schema.badParam(name, value);
                }
            }
        });
        paramRules.put("rrulparam", xparamsOnly);
        paramRules.put("exrparam", xparamsOnly);
        contentRules.put("rdtval", new IcalSchema.ContentRule(){

            public void apply(IcalSchema schema, String content, IcalObject target) throws ParseException {
                RDateList rdates = (RDateList)target;
                String[] parts = COMMA.split(content);
                DateValue[] datesUtc = new DateValue[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    String part = parts[i];
                    datesUtc[i] = IcalParseUtil.parseDateValue(part, rdates.getTzid());
                }
                rdates.setDatesUtc(datesUtc);
            }
        });
        PARAM_RULES = Collections.unmodifiableMap(paramRules);
        CONTENT_RULES = Collections.unmodifiableMap(contentRules);
        OBJECT_RULES = Collections.unmodifiableMap(objectRules);
        XFORM_RULES = Collections.unmodifiableMap(xformRules);
    }
}

