package com.todoroo.astrid.tags;

import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import org.fdroid.taskstrid.R;
import com.todoroo.andlib.sql.Criterion;
import com.todoroo.andlib.sql.Join;
import com.todoroo.andlib.sql.Query;
import com.todoroo.astrid.api.AstridApiConstants;
import com.todoroo.astrid.api.CustomFilterCriterion;
import com.todoroo.astrid.api.MultipleSelectCriterion;
import com.todoroo.astrid.api.TextInputCriterion;
import com.todoroo.astrid.dao.MetadataDao;
import com.todoroo.astrid.dao.TaskDao;
import com.todoroo.astrid.data.Metadata;
import com.todoroo.astrid.data.Task;

public class TagCustomFilterCriteriaExposer extends BroadcastReceiver {
    private static final String IDENTIFIER_TAG_IS = "tag_is"; //$NON-NLS-1$
    private static final String IDENTIFIER_TAG_CONTAINS = "tag_contains"; //$NON-NLS-1$

    @Override
    public void onReceive(Context context, Intent intent) {
        Resources r = context.getResources();

        CustomFilterCriterion[] ret = new CustomFilterCriterion[2];
        int j = 0;

        // built in criteria: tags
        {
            TagService.Tag[] tags = TagService.getInstance().getGroupedTags(TagService.GROUPED_TAGS_BY_SIZE,
                            TaskDao.TaskCriteria.activeAndVisible());
            String[] tagNames = new String[tags.length];
            for(int i = 0; i < tags.length; i++)
                tagNames[i] = tags[i].tag;
            ContentValues values = new ContentValues();
            values.put(Metadata.KEY.name, TagService.KEY);
            values.put(TagService.TAG.name, "?");
            CustomFilterCriterion criterion = new MultipleSelectCriterion(
                    IDENTIFIER_TAG_IS,
                    context.getString(R.string.CFC_tag_text),
                    Query.select(Metadata.TASK).from(Metadata.TABLE).join(Join.inner(
                                Task.TABLE, Metadata.TASK.eq(Task.ID))).where(Criterion.and(
                            TaskDao.TaskCriteria.activeAndVisible(),
                            MetadataDao.MetadataCriteria.withKey(TagService.KEY),
                            TagService.TAG.eq("?"))).toString(),
                    values, tagNames, tagNames,
                    ((BitmapDrawable)r.getDrawable(R.drawable.filter_tags1)).getBitmap(),
                    context.getString(R.string.CFC_tag_name));
            ret[j++] = criterion;
        }

        // built in criteria: tags containing X
        {
            CustomFilterCriterion criterion = new TextInputCriterion(
                            IDENTIFIER_TAG_CONTAINS,
                            context.getString(R.string.CFC_tag_contains_text),
                            Query.select(Metadata.TASK).from(Metadata.TABLE).join(Join.inner(
                                    Task.TABLE, Metadata.TASK.eq(Task.ID))).where(Criterion.and(
                                            TaskDao.TaskCriteria.activeAndVisible(),
                                            MetadataDao.MetadataCriteria.withKey(TagService.KEY),
                                            TagService.TAG.like("%?%"))).toString(),
                                            null, context.getString(R.string.CFC_tag_contains_name), "",
                                            ((BitmapDrawable)r.getDrawable(R.drawable.filter_tags2)).getBitmap(),
                                            context.getString(R.string.CFC_tag_contains_name));
            ret[j++] = criterion;
        }

        // transmit filter list
        Intent broadcastIntent = new Intent(AstridApiConstants.BROADCAST_SEND_CUSTOM_FILTER_CRITERIA);
        broadcastIntent.putExtra(AstridApiConstants.EXTRAS_RESPONSE, ret);
        broadcastIntent.putExtra(AstridApiConstants.EXTRAS_ADDON, TagsPlugin.IDENTIFIER);
        context.sendBroadcast(broadcastIntent, AstridApiConstants.PERMISSION_READ);

    }
}
