/**
 * See the file "LICENSE" for the full license governing this code.
 */

package com.todoroo.astrid.service;

import android.content.Context;

import org.fdroid.taskstrid.R;
import com.todoroo.andlib.utility.Preferences;

public class StatisticsService {

    /**
     * Indicate session started
     *
     * @param context
     */
    public static void sessionStart(Context context) {
        if(dontCollectStatistics())
            return;
    }

    /**
     * Indicate session ended
     *
     * @param context
     */
    public static void sessionStop(Context context) {
        if(dontCollectStatistics())
            return;
    }

    public static void reportError(String name, String message, String trace) {
        if(dontCollectStatistics())
            return;
    }

    public static void reportEvent(String event) {
        if(dontCollectStatistics())
            return;
    }

    private static boolean dontCollectStatistics() {
        return !Preferences.getBoolean(R.string.p_statistics, true);
    }

}
