/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.dashclock.api;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.apps.dashclock.api.ExtensionData;
import com.google.android.apps.dashclock.api.internal.IExtension;
import com.google.android.apps.dashclock.api.internal.IExtensionHost;

public abstract class DashClockExtension
extends Service {
    private static final String TAG = "DashClockExtension";
    public static final int UPDATE_REASON_UNKNOWN = 0;
    public static final int UPDATE_REASON_INITIAL = 1;
    public static final int UPDATE_REASON_PERIODIC = 2;
    public static final int UPDATE_REASON_SETTINGS_CHANGED = 3;
    public static final int UPDATE_REASON_CONTENT_CHANGED = 4;
    public static final int UPDATE_REASON_SCREEN_ON = 5;
    public static final String ACTION_EXTENSION = "com.google.android.apps.dashclock.Extension";
    public static final String PERMISSION_READ_EXTENSION_DATA = "com.google.android.apps.dashclock.permission.READ_EXTENSION_DATA";
    private boolean mInitialized = false;
    private IExtensionHost mHost;
    private volatile Looper mServiceLooper;
    private volatile Handler mServiceHandler;
    private IExtension.Stub mBinder = new IExtension.Stub(){

        @Override
        public void onInitialize(IExtensionHost host, boolean isReconnect) throws RemoteException {
            if (DashClockExtension.this.checkCallingOrSelfPermission(DashClockExtension.PERMISSION_READ_EXTENSION_DATA) != 0) {
                throw new SecurityException("Caller does not have the READ_EXTENSION_DATA permission.");
            }
            DashClockExtension.this.mHost = host;
            if (!DashClockExtension.this.mInitialized) {
                DashClockExtension.this.onInitialize(isReconnect);
                DashClockExtension.this.mInitialized = true;
            }
        }

        @Override
        public void onUpdate(final int reason) throws RemoteException {
            if (DashClockExtension.this.checkCallingOrSelfPermission(DashClockExtension.PERMISSION_READ_EXTENSION_DATA) != 0) {
                throw new SecurityException("Caller does not have the READ_EXTENSION_DATA permission.");
            }
            if (!DashClockExtension.this.mInitialized) {
                return;
            }
            DashClockExtension.this.mServiceHandler.post(new Runnable(){

                @Override
                public void run() {
                    DashClockExtension.this.onUpdateData(reason);
                }
            });
        }
    };

    protected DashClockExtension() {
    }

    public void onCreate() {
        super.onCreate();
        HandlerThread thread = new HandlerThread("DashClockExtension:" + ((Object)((Object)this)).getClass().getSimpleName());
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new Handler(this.mServiceLooper);
    }

    public void onDestroy() {
        this.mServiceHandler.removeCallbacksAndMessages(null);
        this.mServiceLooper.quit();
    }

    public final IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    protected void onInitialize(boolean isReconnect) {
    }

    protected abstract void onUpdateData(int var1);

    protected final void publishUpdate(ExtensionData data) {
        try {
            this.mHost.publishUpdate(data);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Couldn't publish updated extension data.", (Throwable)e);
        }
    }

    protected final void addWatchContentUris(String[] uris) {
        try {
            this.mHost.addWatchContentUris(uris);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Couldn't watch content URIs.", (Throwable)e);
        }
    }

    protected final void setUpdateWhenScreenOn(boolean updateWhenScreenOn) {
        try {
            this.mHost.setUpdateWhenScreenOn(updateWhenScreenOn);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Couldn't set the extension to update upon ACTION_SCREEN_ON.", (Throwable)e);
        }
    }
}

