
minetest.register_node(":default:rail", {
	description = "Rail",
	drawtype = "raillike",
	tiles = {
		"default_rail.png", "default_rail_curved.png",
		"default_rail_t_junction.png", "default_rail_crossing.png"
	},
	inventory_image = "default_rail.png",
	wield_image = "default_rail.png",
	paramtype = "light",
	sunlight_propagates = true,
	is_ground_content = false,
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {-1/2, -1/2, -1/2, 1/2, -1/2 + 1/16, 1/2},
	},
	groups = boost_cart:get_rail_groups(),
})

-- add alias for old copper rails
minetest.register_alias("carts:copperrail", "defaulf:rail")

boost_cart:register_rail("carts:powerrail", {
	description = "Powered rail",
	tiles = {
		"carts_rail_pwr.png", "carts_rail_curved_pwr.png",
		"carts_rail_t_junction_pwr.png", "carts_rail_crossing_pwr.png"
	},
	groups = boost_cart:get_rail_groups(),
}, {acceleration = 0.5})

minetest.register_craft({
	output = ":carts:powerrail 6",
	recipe = {
		{"default:steel_ingot", "default:mese_crystal_fragment", "default:steel_ingot"},
		{"default:steel_ingot", "group:stick", "default:steel_ingot"},
		{"default:steel_ingot", "default:mese_crystal_fragment", "default:steel_ingot"},
	}
})

boost_cart:register_rail("carts:brakerail", {
	description = "Brake rail",
	tiles = {
		"carts_rail_brk.png", "carts_rail_curved_brk.png",
		"carts_rail_t_junction_brk.png", "carts_rail_crossing_brk.png"
	},
	groups = boost_cart:get_rail_groups(),
}, {acceleration = -0.5})

minetest.register_craft({
	output = "carts:brakerail 6",
	recipe = {
		{"default:steel_ingot", "default:coal_lump", "default:steel_ingot"},
		{"default:steel_ingot", "group:stick", "default:steel_ingot"},
		{"default:steel_ingot", "default:coal_lump", "default:steel_ingot"},
	}
})
