/*
filecache.h
Copyright (C) 2013 celeron55, Perttu Ahola <celeron55@gmail.com>
Copyright (C) 2013 Jonathan Neuschäfer <j.neuschaefer@gmx.net>
*/

/*
This file is part of Freeminer.

Freeminer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Freeminer  is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Freeminer.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef FILECACHE_HEADER
#define FILECACHE_HEADER

#include <string>
#include <iostream>

class FileCache
{
public:
	/*
		'dir' is the file cache directory to use.
	*/
	FileCache(std::string dir):
		m_dir(dir)
	{
	}
	
	bool update(const std::string &name, const std::string &data);
	bool load(const std::string &name, std::ostream &os);
private:
	std::string m_dir;

	bool loadByPath(const std::string &path, std::ostream &os);
	bool updateByPath(const std::string &path, const std::string &data);
};

#endif
