*EasyRSS* is an Android app for RSS services compatible with Google Reader API.

The recommended RSS back-end service is [FreshRSS](http://freshrss.org/).

# Features
- Sync with RSS services compatible with Google Reader API
- Image downloading for off-line reading
- Simple swipe between starred/all/unread items
- Manage starred items
- View items by tag or subscription
- State saving & syncing
- Slide up & down to move between items
- Font size adjustment

# Download
* [![f-droid-button_bigger](https://cloud.githubusercontent.com/assets/1008324/7830569/e744b9ae-044e-11e5-9009-ab3285d216ab.png)](https://f-droid.org/repository/browse/?fdid=org.freshrss.easyrss)
* [APK available](../../releases/)

## What’s new?
See [changelog](./CHANGELOG.md)

# Screenshots

![screenshot_2014-03-02-17-35-12](https://f.cloud.github.com/assets/1008324/2304613/dd61e240-a22a-11e3-87f3-518f3a8aabca.png)

![screenshot_2014-03-02-00-27-06](https://f.cloud.github.com/assets/1008324/2303004/6701c156-a199-11e3-95b4-dd1db8b17d82.png)

# Compatible RSS services
* [FreshRSS](http://freshrss.org/) https://github.com/FreshRSS/FreshRSS
 * `https://your.server.example/FreshRSS/p/api/greader.php`
 * Documentation: [English](https://github.com/FreshRSS/FreshRSS/issues/443#issuecomment-36666133), [français](https://github.com/FreshRSS/FreshRSS/issues/957#issuecomment-133581712) 

## Credits
[Fork](https://github.com/Alkarex/EasyRSS) by [Alexandre Alapetite](http://alexandre.alapetite.fr/) adding the possibility to use any back-end server.
The [original project](http://easyrss.pursuer.me/) by [Zheng Sun](http://pursuer.me/) was [released as open source](https://github.com/davidsun/EasyRSS)
and stopped at version 0.5.x when its back-end service [Google Reader closed in July 2013](http://www.google.com/reader/about/).

### Translations
Spanish @teki207,
Japanese [@Soyofuki](https://github.com/Soyofuki),
Danish [@simongray](https://github.com/simongray) + [@Alkarex](https://github.com/Alkarex),
French [@Alkarex](https://github.com/Alkarex)

### Related Open Source projects

* [FreshRSS](https://github.com/FreshRSS/FreshRSS): A free, self-hostable RSS aggregator, compatible with Google Reader API.
* [HtmlCleaner](https://github.com/davidsun/HtmlCleaner): Open-source HTML parser, originally by [Vladimir Nikic](http://htmlcleaner.sourceforge.net/).
* [HorizontalPager](https://github.com/davidsun/horizontalpager): An Android horizontally scrolling view that snaps to child pages neatly and supports nested vertically scrolling child views.

# Reviews
* (fr) [EasyRSS : L’application android opensource de la semaine | Wilfried Caruel](http://wilfriedcaruel.svnet.fr/2014/05/easyrss-lapplication-android-opensource-de-la-semaine/)
